/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.AegisReader;
import org.apache.cxf.aegis.AegisWriter;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.jaxrs.provider.AbstractAegisProvider;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
public class AegisElementProvider
extends AbstractAegisProvider {
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        AegisContext context = this.getAegisContext(type, genericType);
        AegisReader<XMLStreamReader> aegisReader = context.createXMLStreamReader();
        try {
            XMLStreamReader xmlStreamReader = this.createStreamReader(type, is);
            return aegisReader.read(xmlStreamReader);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected XMLStreamReader createStreamReader(Class<?> type, InputStream is) throws Exception {
        return StaxUtils.createXMLStreamReader(is);
    }

    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (type == null) {
            type = obj.getClass();
        }
        AegisContext context = this.getAegisContext(type, genericType);
        org.apache.cxf.aegis.type.Type aegisType = TypeUtil.getWriteTypeStandalone(context, obj, null);
        AegisWriter<XMLStreamWriter> aegisWriter = context.createXMLStreamWriter();
        try {
            XMLStreamWriter xmlStreamWriter = this.createStreamWriter(type, os);
            xmlStreamWriter.writeStartDocument();
            aegisWriter.write(obj, aegisType.getSchemaType(), false, xmlStreamWriter, aegisType);
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.close();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected XMLStreamWriter createStreamWriter(Class<?> type, OutputStream os) throws Exception {
        return StaxUtils.createXMLStreamWriter(os);
    }
}

