/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.util.Map;
import org.apache.cxf.BusException;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;

public class ClientFactoryBean
extends AbstractWSDLBasedEndpointFactory {
    public ClientFactoryBean() {
        this(new ReflectionServiceFactoryBean());
    }

    public ClientFactoryBean(ReflectionServiceFactoryBean factory) {
        super(factory);
    }

    public Client create() {
        this.getServiceFactory().reset();
        if (this.getServiceFactory().getProperties() == null) {
            this.getServiceFactory().setProperties(this.properties);
        } else if (this.properties != null) {
            this.getServiceFactory().getProperties().putAll(this.properties);
        }
        Client client = null;
        try {
            Endpoint ep = this.createEndpoint();
            this.applyProperties(ep);
            client = this.createClient(ep);
            this.initializeAnnotationInterceptors(ep, this.getServiceClass());
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException(e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException(e);
        }
        this.applyFeatures(client);
        return client;
    }

    protected Client createClient(Endpoint ep) {
        return new ClientImpl(this.getBus(), ep, this.getConduitSelector());
    }

    protected void applyFeatures(Client client) {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(client, this.getBus());
            }
        }
    }

    protected void applyProperties(Endpoint ep) {
        Map<String, Object> props = this.getProperties();
        if (props != null && props.get(AuthorizationPolicy.class.getName()) != null) {
            AuthorizationPolicy ap = (AuthorizationPolicy)props.get(AuthorizationPolicy.class.getName());
            ep.getEndpointInfo().addExtensor(ap);
        }
    }
}

