/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.cxf.BusException;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.BeanInvoker;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.SingletonFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFactoryBean
extends AbstractWSDLBasedEndpointFactory {
    private Server server;
    private boolean start = true;
    private Object serviceBean;
    private List<String> schemaLocations;
    private Invoker invoker;

    public ServerFactoryBean() {
        this(new ReflectionServiceFactoryBean());
    }

    public ServerFactoryBean(ReflectionServiceFactoryBean sbean) {
        super(sbean);
    }

    public String getBeanName() {
        return this.getClass().getName();
    }

    public Server create() {
        try {
            if (this.getServiceFactory().getProperties() == null) {
                this.getServiceFactory().setProperties(this.getProperties());
            } else if (this.getProperties() != null) {
                this.getServiceFactory().getProperties().putAll(this.getProperties());
            }
            if (this.serviceBean != null && this.getServiceClass() == null) {
                this.setServiceClass(ClassHelper.getRealClass(this.serviceBean));
            }
            if (this.invoker != null) {
                this.getServiceFactory().setInvoker(this.invoker);
            } else if (this.serviceBean != null) {
                this.invoker = this.createInvoker();
                this.getServiceFactory().setInvoker(this.invoker);
            }
            Endpoint ep = this.createEndpoint();
            this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
            if (ep.getService().getInvoker() == null) {
                if (this.invoker == null) {
                    ep.getService().setInvoker(this.createInvoker());
                } else {
                    ep.getService().setInvoker(this.invoker);
                }
            }
            if (this.start) {
                this.server.start();
            }
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException(e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException(e);
        }
        catch (IOException e) {
            throw new ServiceConstructionException(e);
        }
        if (this.serviceBean != null) {
            this.initializeAnnotationInterceptors(this.server.getEndpoint(), ClassHelper.getRealClass(this.getServiceBean()));
        } else if (this.getServiceClass() != null) {
            this.initializeAnnotationInterceptors(this.server.getEndpoint(), this.getServiceClass());
        }
        this.applyFeatures();
        return this.server;
    }

    @Override
    protected void initializeServiceFactory() {
        super.initializeServiceFactory();
        this.getServiceFactory().setSchemaLocations(this.schemaLocations);
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected void applyExtraClass() {
        Map<String, Object> props = this.getProperties();
        if (props != null && props.get("jaxb.additionalContextClasses") != null) {
            Class[] extraClass = (Class[])this.getProperties().get("jaxb.additionalContextClasses");
            DataBinding dataBinding = this.getServiceFactory().getDataBinding();
            if (dataBinding instanceof JAXBDataBinding) {
                ((JAXBDataBinding)dataBinding).setExtraClass(extraClass);
            }
        }
    }

    protected Invoker createInvoker() {
        if (this.getServiceBean() == null) {
            return new FactoryInvoker(new SingletonFactory(this.getServiceClass()));
        }
        return new BeanInvoker(this.getServiceBean());
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public Object getServiceBean() {
        return this.serviceBean;
    }

    public Class<?> getServiceBeanClass() {
        if (this.serviceBean != null) {
            return ClassHelper.getRealClass(this.serviceBean);
        }
        return this.getServiceFactory().getServiceClass();
    }

    public void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(List<String> schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setWsdlLocation(String location) {
        this.setWsdlURL(location);
    }

    public String getWsdlLocation() {
        return this.getWsdlURL();
    }
}

