/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.jaxb.JAXBBeanInfo;
import org.apache.cxf.jaxb.JAXBContextProxy;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractJAXBProvider.class);
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXBProvider.class);
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static final String CHARSET_PARAMETER = "charset";
    private static Map<String, JAXBContext> packageContexts = new WeakHashMap<String, JAXBContext>();
    private static Map<Class<?>, JAXBContext> classContexts = new WeakHashMap();
    private static Set<Class<?>> collectionContextClasses = new HashSet();
    private static JAXBContext collectionContext;
    protected Map<String, String> jaxbElementClassMap;
    protected boolean unmarshalAsJaxbElement;
    protected boolean marshalAsJaxbElement;
    private MessageContext mc;
    private Schema schema;
    private String collectionWrapperName;
    private Map<String, String> collectionWrapperMap;
    private List<String> jaxbElementClassNames;
    private Map<String, Object> cProperties;

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.cProperties = contextProperties;
    }

    public void setUnmarshallAsJaxbElement(boolean value) {
        this.unmarshalAsJaxbElement = value;
    }

    public void setMarshallAsJaxbElement(boolean value) {
        this.marshalAsJaxbElement = value;
    }

    public void setJaxbElementClassNames(List<String> names) {
        this.jaxbElementClassNames = names;
    }

    public void setJaxbElementClassMap(Map<String, String> map) {
        this.jaxbElementClassMap = map;
    }

    protected Object convertToJaxbElementIfNeeded(Object obj, Class<?> cls, Type genericType) throws Exception {
        QName name = null;
        if (this.jaxbElementClassNames != null && this.jaxbElementClassNames.contains(cls.getName()) || this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(cls.getName())) {
            name = this.jaxbElementClassMap != null ? this.convertStringToQName(this.jaxbElementClassMap.get(cls.getName())) : this.getJaxbQName(cls, genericType, obj, false);
        }
        if (name == null && this.marshalAsJaxbElement) {
            name = this.convertStringToQName(cls.getSimpleName());
        }
        if (name != null) {
            return new JAXBElement(name, cls, null, obj);
        }
        return obj;
    }

    public void setCollectionWrapperName(String wName) {
        this.collectionWrapperName = wName;
    }

    public void setCollectionWrapperMap(Map<String, String> map) {
        this.collectionWrapperMap = map;
    }

    protected void setContext(MessageContext context) {
        this.mc = context;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (InjectionUtils.isSupportedCollectionOrArray(type) && (type = InjectionUtils.getActualType(genericType)) == null) {
            return false;
        }
        return this.unmarshalAsJaxbElement || this.isSupported(type, genericType, anns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getCollectionContext(Class<?> type) throws JAXBException {
        Set<Class<?>> set = collectionContextClasses;
        synchronized (set) {
            if (!collectionContextClasses.contains(type)) {
                collectionContextClasses.add(CollectionWrapper.class);
                collectionContextClasses.add(type);
            }
            collectionContext = JAXBContext.newInstance((Class[])collectionContextClasses.toArray(new Class[0]), this.cProperties);
            return collectionContext;
        }
    }

    protected QName getCollectionWrapperQName(Class<?> cls, Type type, Object object, boolean pluralName) throws Exception {
        String name = this.getCollectionWrapperName(cls);
        if (name == null) {
            return this.getJaxbQName(cls, type, object, pluralName);
        }
        return this.convertStringToQName(name);
    }

    private QName convertStringToQName(String name) {
        int ind1 = name.indexOf(123);
        if (ind1 != 0) {
            return new QName(name);
        }
        int ind2 = name.indexOf(125);
        if (ind2 <= ind1 + 1 || ind2 >= name.length() - 1) {
            return null;
        }
        String ns = name.substring(ind1 + 1, ind2);
        String localName = name.substring(ind2 + 1);
        return new QName(ns, localName);
    }

    private String getCollectionWrapperName(Class<?> cls) {
        if (this.collectionWrapperName != null) {
            return this.collectionWrapperName;
        }
        if (this.collectionWrapperMap != null) {
            return this.collectionWrapperMap.get(cls.getName());
        }
        return null;
    }

    protected QName getJaxbQName(Class<?> cls, Type type, Object object, boolean pluralName) throws Exception {
        if (cls == JAXBElement.class) {
            return object != null ? ((JAXBElement)object).getName() : null;
        }
        XmlRootElement root = cls.getAnnotation(XmlRootElement.class);
        QName qname = null;
        if (root != null) {
            String packageNs;
            String namespace = this.getNamespace(root.namespace());
            if ("".equals(namespace) && (packageNs = JAXBUtils.getPackageNamespace(cls)) != null) {
                namespace = this.getNamespace(packageNs);
            }
            String name = this.getLocalName(root.name(), cls.getSimpleName(), pluralName);
            return new QName(namespace, name);
        }
        JAXBContext context = this.getJAXBContext(cls, type);
        JAXBContextProxy proxy = ReflectionInvokationHandler.createProxyWrapper(context, JAXBContextProxy.class);
        JAXBBeanInfo info = JAXBUtils.getBeanInfo(proxy, cls);
        if (info != null) {
            try {
                Object instance = object == null ? cls.newInstance() : object;
                String name = this.getLocalName(info.getElementLocalName(instance), cls.getSimpleName(), pluralName);
                String namespace = this.getNamespace(info.getElementNamespaceURI(instance));
                return new QName(namespace, name);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return qname;
    }

    private String getLocalName(String name, String clsName, boolean pluralName) {
        if ("##default".equals(name)) {
            name = clsName;
            name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        }
        if (pluralName) {
            name = name + 's';
        }
        return name;
    }

    private String getNamespace(String namespace) {
        if ("##default".equals(namespace)) {
            return "";
        }
        return namespace;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return this.marshalAsJaxbElement || this.isSupported(type, genericType, anns);
    }

    public void setSchemaLocations(List<String> locations) {
        this.schema = SchemaHandler.createSchema(locations, this.getBus());
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected MessageContext getContext() {
        return this.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getJAXBContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBContext customContext;
        ContextResolver resolver;
        if (this.mc != null && (resolver = this.mc.getResolver(ContextResolver.class, JAXBContext.class)) != null && (customContext = (JAXBContext)resolver.getContext(type)) != null) {
            return customContext;
        }
        resolver = classContexts;
        synchronized (resolver) {
            JAXBContext context = classContexts.get(type);
            if (context != null) {
                return context;
            }
        }
        JAXBContext context = this.getPackageContext(type);
        if (context == null && type != genericType) {
            context = this.getPackageContext(InjectionUtils.getActualType(genericType));
        }
        return context != null ? context : this.getClassContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getClassContext(Class<?> type) throws JAXBException {
        Map<Class<?>, JAXBContext> map = classContexts;
        synchronized (map) {
            JAXBContext context = classContexts.get(type);
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{type}, this.cProperties);
                classContexts.put(type, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getPackageContext(Class<?> type) {
        if (type == null || type == JAXBElement.class) {
            return null;
        }
        Map<String, JAXBContext> map = packageContexts;
        synchronized (map) {
            String packageName = PackageUtils.getPackageName(type);
            JAXBContext context = packageContexts.get(packageName);
            if (context == null) {
                try {
                    context = JAXBContext.newInstance((String)packageName, (ClassLoader)type.getClassLoader(), this.cProperties);
                    packageContexts.put(packageName, context);
                }
                catch (JAXBException ex) {
                    LOG.fine("Error creating a JAXBContext using ObjectFactory : " + ex.getMessage());
                    return null;
                }
            }
            return context;
        }
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] anns) {
        if (this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(type.getName())) {
            return true;
        }
        return type.getAnnotation(XmlRootElement.class) != null || JAXBElement.class.isAssignableFrom(type) || this.objectFactoryForClass(type) || type != genericType && this.objectFactoryForType(genericType) || this.adapterAvailable(type, anns) || type.getResource("jaxb.index") != null;
    }

    protected boolean adapterAvailable(Class<?> type, Annotation[] anns) {
        return AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class) != null || type.getAnnotation(XmlJavaTypeAdapter.class) != null;
    }

    protected boolean objectFactoryForClass(Class<?> type) {
        try {
            return type.getClassLoader().loadClass(PackageUtils.getPackageName(type) + ".ObjectFactory") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean objectFactoryForType(Type genericType) {
        return this.objectFactoryForClass(InjectionUtils.getActualType(genericType));
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType) throws JAXBException {
        return this.createUnmarshaller(cls, genericType, false);
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType, boolean isCollection) throws JAXBException {
        JAXBContext context = isCollection ? this.getCollectionContext(cls) : this.getJAXBContext(cls, genericType);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller(Object obj, Class<?> cls, Type genericType, String enc) throws JAXBException {
        Class objClazz = JAXBElement.class.isAssignableFrom(cls) ? ((JAXBElement)obj).getDeclaredType() : cls;
        JAXBContext context = this.getJAXBContext(objClazz, genericType);
        Marshaller marshaller = context.createMarshaller();
        if (enc != null) {
            marshaller.setProperty("jaxb.encoding", (Object)enc);
        }
        return marshaller;
    }

    protected String getEncoding(MediaType mt, MultivaluedMap<String, Object> headers) {
        String enc = (String)mt.getParameters().get(CHARSET_PARAMETER);
        if (enc == null) {
            return null;
        }
        try {
            "0".getBytes(enc);
            return enc;
        }
        catch (UnsupportedEncodingException ex) {
            String message = new Message("UNSUPPORTED_ENCODING", BUNDLE, enc).toString();
            LOG.warning(message);
            headers.putSingle((Object)"Content-Type", (Object)(JAXRSUtils.removeMediaTypeParameter(mt, CHARSET_PARAMETER) + ';' + CHARSET_PARAMETER + "=UTF-8"));
            return null;
        }
    }

    protected Class<?> getActualType(Class<?> type, Type genericType, Annotation[] anns) {
        Class<Object> theType = null;
        theType = JAXBElement.class.isAssignableFrom(type) ? InjectionUtils.getActualType(genericType) : type;
        XmlJavaTypeAdapter adapter = this.getAdapter(theType, anns);
        if (adapter != null) {
            if (adapter.type() != XmlJavaTypeAdapter.DEFAULT.class) {
                theType = adapter.type();
            } else {
                Type[] types = InjectionUtils.getActualTypes(adapter.value().getGenericSuperclass());
                if (types != null && types.length == 2) {
                    theType = (Class)types[0];
                }
            }
        }
        return theType;
    }

    protected Object checkAdapter(Object obj, Annotation[] anns, boolean marshal) {
        XmlJavaTypeAdapter typeAdapter = this.getAdapter(obj.getClass(), anns);
        if (typeAdapter != null) {
            try {
                XmlAdapter xmlAdapter = (XmlAdapter)typeAdapter.value().newInstance();
                if (marshal) {
                    return xmlAdapter.marshal(obj);
                }
                return xmlAdapter.unmarshal(obj);
            }
            catch (Exception ex) {
                LOG.warning("Problem using the XmlJavaTypeAdapter");
                ex.printStackTrace();
            }
        }
        return obj;
    }

    protected XmlJavaTypeAdapter getAdapter(Class<?> type, Annotation[] anns) {
        XmlJavaTypeAdapter typeAdapter = AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class);
        if (typeAdapter == null) {
            typeAdapter = type.getAnnotation(XmlJavaTypeAdapter.class);
        }
        return typeAdapter;
    }

    protected Schema getSchema() {
        return this.schema;
    }

    static void clearContexts() {
        classContexts.clear();
        packageContexts.clear();
    }

    protected static void handleJAXBException(JAXBException e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        LOG.warning(sw.toString());
        StringBuilder sb = new StringBuilder();
        if (e.getMessage() != null) {
            sb.append(e.getMessage()).append(". ");
        }
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            sb.append(e.getCause().getMessage()).append(". ");
        }
        if (e.getLinkedException() != null && e.getLinkedException().getMessage() != null) {
            sb.append(e.getLinkedException().getMessage()).append(". ");
        }
        Throwable t = e.getLinkedException() != null ? e.getLinkedException() : (e.getCause() != null ? e.getCause() : e);
        String message = new Message("JAXB_EXCEPTION", BUNDLE, sb.toString()).toString();
        Response r = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)message).build();
        throw new WebApplicationException(t, r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    protected static class CollectionWrapper {
        @XmlAnyElement(lax=true)
        private List<?> l;

        protected CollectionWrapper() {
        }

        public void setList(List<?> list) {
            this.l = list;
        }

        public List<?> getList() {
            if (this.l == null) {
                this.l = new ArrayList();
            }
            return this.l;
        }

        public <T> Object getCollectionOrArray(Class<T> type, Class<?> origType) {
            Object first;
            List<?> theList = this.getList();
            if (theList.size() > 0 && (first = theList.get(0)) instanceof JAXBElement && !JAXBElement.class.isAssignableFrom(type)) {
                ArrayList newList = new ArrayList(theList.size());
                for (Object o : theList) {
                    newList.add(((JAXBElement)o).getValue());
                }
                theList = newList;
            }
            if (origType.isArray()) {
                Object[] values = (Object[])Array.newInstance(type, theList.size());
                for (int i = 0; i < theList.size(); ++i) {
                    values[i] = theList.get(i);
                }
                return values;
            }
            if (origType == Set.class) {
                return new HashSet(theList);
            }
            return theList;
        }
    }
}

