/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.staxutils.OverlayW3CDOMStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageModeOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    MessageModeOutInterceptorInternal internal;
    SAAJOutInterceptor saajOut;
    Class<?> type;
    QName bindingName;

    public MessageModeOutInterceptor(SAAJOutInterceptor saajOut, QName bname) {
        super("prepare-send");
        this.saajOut = saajOut;
        this.bindingName = bname;
        this.internal = new MessageModeOutInterceptorInternal();
    }

    public MessageModeOutInterceptor(Class<?> t, QName bname) {
        super("prepare-send");
        this.type = t;
        this.bindingName = bname;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        if (!this.bindingName.equals(message.getExchange().get(BindingOperationInfo.class).getBinding().getName())) {
            return;
        }
        if (this.saajOut != null) {
            this.doSoap(message);
        } else if (DataSource.class.isAssignableFrom(this.type)) {
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            DataSource ds = (DataSource)list.get(0);
            String ct = ds.getContentType();
            if (ct.toLowerCase().contains("multipart/related")) {
                MessageImpl msg = new MessageImpl();
                msg.setExchange(message.getExchange());
                msg.put("Content-Type", ct);
                try {
                    msg.setContent(InputStream.class, ds.getInputStream());
                    AttachmentDeserializer deser = new AttachmentDeserializer(msg);
                    deser.initializeAttachments();
                }
                catch (IOException ex) {
                    throw new Fault(ex);
                }
                message.setAttachments(msg.getAttachments());
                final InputStream in = msg.getContent(InputStream.class);
                final String ct2 = (String)msg.get("Content-Type");
                list.set(0, new DataSource(){

                    public String getContentType() {
                        return ct2;
                    }

                    public InputStream getInputStream() throws IOException {
                        return in;
                    }

                    public String getName() {
                        return ct2;
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return null;
                    }
                });
            } else if (!ct.toLowerCase().contains("xml")) {
                OutputStream out = message.getContent(OutputStream.class);
                message.put("Content-Type", ct);
                try {
                    InputStream in = ds.getInputStream();
                    IOUtils.copy(in, out);
                    in.close();
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new Fault(e);
                }
                list.remove(0);
                out = new CachedOutputStream();
                message.setContent(OutputStream.class, out);
                XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(out);
                message.setContent(XMLStreamWriter.class, writer);
            }
        }
    }

    private void doSoap(Message message) {
        SOAPMessage soapMessage;
        MessageContentsList list = (MessageContentsList)message.getContent(List.class);
        Object o = list.get(0);
        if (o instanceof SOAPMessage && (soapMessage = (SOAPMessage)o).countAttachments() > 0) {
            message.put("write.attachments", Boolean.TRUE);
        }
        message.getInterceptorChain().add(this.internal);
    }

    private class MessageModeOutInterceptorInternal
    extends AbstractSoapInterceptor {
        MessageModeOutInterceptorInternal() {
            super("pre-protocol");
            this.addBefore(SAAJOutInterceptor.class.getName());
        }

        public void handleMessage(SoapMessage message) throws Fault {
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            Object o = list.get(0);
            SOAPMessage soapMessage = null;
            if (o instanceof SOAPMessage) {
                soapMessage = (SOAPMessage)o;
                if (soapMessage.countAttachments() > 0) {
                    message.put("write.attachments", (Object)Boolean.TRUE);
                }
            } else {
                try {
                    MessageFactory factory = MessageModeOutInterceptor.this.saajOut.getFactory(message);
                    soapMessage = factory.createMessage();
                    SOAPPart part = soapMessage.getSOAPPart();
                    if (o instanceof Source) {
                        StaxUtils.copy((Source)o, (XMLStreamWriter)new W3CDOMStreamWriter((Document)part));
                    }
                }
                catch (SOAPException e) {
                    throw new SoapFault("Error creating SOAPMessage", (Throwable)e, message.getVersion().getSender());
                }
                catch (XMLStreamException e) {
                    throw new SoapFault("Error creating SOAPMessage", (Throwable)e, message.getVersion().getSender());
                }
            }
            message.setContent(SOAPMessage.class, soapMessage);
            if (!message.containsKey(SAAJOutInterceptor.ORIGINAL_XML_WRITER)) {
                XMLStreamWriter origWriter = message.getContent(XMLStreamWriter.class);
                message.put(SAAJOutInterceptor.ORIGINAL_XML_WRITER, (Object)origWriter);
            }
            OverlayW3CDOMStreamWriter writer = new OverlayW3CDOMStreamWriter((Document)soapMessage.getSOAPPart());
            message.setContent(XMLStreamWriter.class, writer);
            message.setContent(SOAPMessage.class, soapMessage);
            DocumentFragment frag = soapMessage.getSOAPPart().createDocumentFragment();
            try {
                SOAPBody body = soapMessage.getSOAPBody();
                Node nd = body.getFirstChild();
                while (nd != null) {
                    body.removeChild(nd);
                    frag.appendChild(nd);
                    nd = soapMessage.getSOAPBody().getFirstChild();
                }
                list.set(0, frag);
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
            BindingOperationInfo bop = message.getExchange().get(BindingOperationInfo.class);
            if (bop != null && bop.isUnwrapped()) {
                bop = bop.getWrappedOperation();
                message.getExchange().put(BindingOperationInfo.class, bop);
            }
            message.getInterceptorChain().add(SAAJOutInterceptor.SAAJOutEndingInterceptor.INSTANCE);
        }
    }
}

