/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.w3c.dom.Node;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static boolean isOutbound(Message message) {
        Exchange exchange = message.getExchange();
        return message != null && exchange != null && (message == exchange.getOutMessage() || message == exchange.getOutFaultMessage());
    }

    public static boolean isFault(Message message) {
        return message != null && message.getExchange() != null && (message == message.getExchange().getInFaultMessage() || message == message.getExchange().getOutFaultMessage());
    }

    public static FaultMode getFaultMode(Message message) {
        if (message != null && message.getExchange() != null && message == message.getExchange().getOutFaultMessage()) {
            FaultMode mode = message.get(FaultMode.class);
            if (null != mode) {
                return mode;
            }
            return FaultMode.RUNTIME_FAULT;
        }
        return null;
    }

    public static boolean isRequestor(Message message) {
        Boolean requestor = (Boolean)message.get("org.apache.cxf.client");
        return requestor != null && requestor != false;
    }

    public static boolean isPartialResponse(Message message) {
        return Boolean.TRUE.equals(message.get("org.apache.cxf.partial.response"));
    }

    public static boolean isTrue(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.TRUE.equals(value) || "true".equalsIgnoreCase(value.toString());
    }

    public static boolean getContextualBoolean(Message m, String key, boolean defaultValue) {
        Object o = m.getContextualProperty(key);
        if (o != null) {
            return MessageUtils.isTrue(o);
        }
        return defaultValue;
    }

    public static boolean isDOMPresent(Message m) {
        for (Class<?> c : m.getContentFormats()) {
            if (!c.equals(Node.class) && !c.getName().equals("javax.xml.soap.SOAPMessage")) continue;
            return true;
        }
        return false;
    }
}

