/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.BindingType;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.corba.processors.idl.AttributeVisitor;
import org.apache.cxf.tools.corba.processors.idl.ConstVisitor;
import org.apache.cxf.tools.corba.processors.idl.DeferredAction;
import org.apache.cxf.tools.corba.processors.idl.DeferredActionCollection;
import org.apache.cxf.tools.corba.processors.idl.ExceptionVisitor;
import org.apache.cxf.tools.corba.processors.idl.ObjectReferenceVisitor;
import org.apache.cxf.tools.corba.processors.idl.OperationVisitor;
import org.apache.cxf.tools.corba.processors.idl.SchemaDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.ScopeNameCollection;
import org.apache.cxf.tools.corba.processors.idl.ScopedNameVisitor;
import org.apache.cxf.tools.corba.processors.idl.TypeDclVisitor;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaType;

public class PortTypeVisitor
extends VisitorBase {
    ExtensionRegistry extReg;
    PortType portType;
    Definition rootDefinition;

    public PortTypeVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlASTVisitor) {
        super(scope, defn, schemaRef, wsdlASTVisitor);
        this.extReg = this.definition.getExtensionRegistry();
        this.rootDefinition = wsdlASTVisitor.getDefinition();
    }

    public static boolean accept(AST node) {
        return node.getType() == 7;
    }

    public void visit(AST node) {
        AST identifierNode = node.getFirstChild();
        if (identifierNode.getFirstChild() == null && identifierNode.getNextSibling() == null) {
            this.visitForwardDeclaredInterface(identifierNode);
        } else {
            this.visitInterface(identifierNode);
        }
    }

    private void visitInterface(AST identifierNode) {
        try {
            String tns;
            String interfaceName = identifierNode.toString();
            Scope interfaceScope = new Scope(this.getScope(), interfaceName);
            this.portType = this.definition.createPortType();
            String portTypeName = interfaceScope.toString();
            XmlSchema newSchema = this.schema;
            if (!this.mapper.isDefaultMapping()) {
                portTypeName = interfaceScope.tail();
                tns = this.mapper.map(interfaceScope);
                newSchema = this.manager.createXmlSchemaForDefinition(this.definition, tns, this.schemas);
                this.definition.addNamespace(interfaceScope.toString("_"), tns);
            }
            tns = this.definition.getTargetNamespace();
            this.portType.setQName(new QName(tns, portTypeName));
            this.definition.addPortType(this.portType);
            this.portType.setUndefined(false);
            Binding binding = this.createBinding(interfaceScope.toString());
            AST specNode = identifierNode.getNextSibling();
            if (specNode.getType() == 12) {
                specNode = specNode.getNextSibling();
            }
            AST exportNode = null;
            if (specNode.getType() == 13) {
                exportNode = specNode.getNextSibling();
            } else if (specNode.getType() == 14) {
                exportNode = this.visitInterfaceInheritanceSpec(specNode, binding, interfaceScope);
                exportNode = exportNode.getNextSibling();
            } else {
                exportNode = specNode;
            }
            while (exportNode != null && exportNode.getType() != 13) {
                VisitorBase visitor;
                if (TypeDclVisitor.accept(exportNode)) {
                    visitor = new TypeDclVisitor(interfaceScope, this.definition, newSchema, this.wsdlVisitor);
                    ((TypeDclVisitor)visitor).visit(exportNode);
                } else if (ConstVisitor.accept(exportNode)) {
                    visitor = new ConstVisitor(interfaceScope, this.definition, newSchema, this.wsdlVisitor);
                    ((ConstVisitor)visitor).visit(exportNode);
                } else if (ExceptionVisitor.accept(exportNode)) {
                    visitor = new ExceptionVisitor(interfaceScope, this.definition, newSchema, this.wsdlVisitor);
                    ((ExceptionVisitor)visitor).visit(exportNode);
                } else if (AttributeVisitor.accept(exportNode)) {
                    AttributeVisitor attributeVisitor = new AttributeVisitor(interfaceScope, this.definition, newSchema, this.wsdlVisitor, this.portType, binding);
                    attributeVisitor.visit(exportNode);
                } else if (OperationVisitor.accept(interfaceScope, this.definition, newSchema, exportNode, this.wsdlVisitor)) {
                    visitor = new OperationVisitor(interfaceScope, this.definition, newSchema, this.wsdlVisitor, this.portType, binding);
                    ((OperationVisitor)visitor).visit(exportNode);
                } else {
                    throw new RuntimeException("[InterfaceVisitor] Invalid IDL: unknown element " + exportNode.toString());
                }
                exportNode = exportNode.getNextSibling();
            }
            Scope scopedName = new Scope(this.getScope(), identifierNode);
            scopedNames.remove(scopedName);
            if (this.wsdlVisitor.getDeferredActions() != null) {
                this.handleDeferredActions(this.wsdlVisitor.getDeferredActions(), scopedName, identifierNode);
            }
            if (!this.mapper.isDefaultMapping()) {
                this.manager.deferAttachSchemaToWSDL(this.definition, newSchema, false);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void handleDeferredActions(DeferredActionCollection deferredActions, Scope scopedName, AST identifierNode) {
        List list = deferredActions.getActions(scopedName);
        if (list != null && !list.isEmpty()) {
            XmlSchemaType stype = null;
            CorbaTypeImpl ctype = null;
            if (ObjectReferenceVisitor.accept(this.getScope(), this.schema, this.definition, identifierNode, this.wsdlVisitor)) {
                ObjectReferenceVisitor visitor = new ObjectReferenceVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
                visitor.visit(identifierNode);
                stype = visitor.getSchemaType();
                ctype = visitor.getCorbaType();
            }
            for (DeferredAction action : list) {
                if (!(action instanceof SchemaDeferredAction) || stype == null || ctype == null) continue;
                SchemaDeferredAction schemaAction = (SchemaDeferredAction)action;
                schemaAction.execute(stype, ctype);
            }
            deferredActions.removeScope(scopedName);
        }
    }

    public Binding createBinding(String scopedPortTypeName) {
        String bname = scopedPortTypeName + "CORBABinding";
        QName bqname = new QName(this.rootDefinition.getTargetNamespace(), bname);
        int count = 0;
        while (this.queryBinding(bqname)) {
            bname = bname + count;
            bqname = new QName(this.rootDefinition.getTargetNamespace(), bname);
        }
        Binding binding = this.rootDefinition.createBinding();
        binding.setPortType(this.portType);
        binding.setQName(bqname);
        try {
            BindingType bindingType = (BindingType)this.extReg.createExtension(Binding.class, CorbaConstants.NE_CORBA_BINDING);
            bindingType.setRepositoryID("IDL:" + scopedPortTypeName.replace('.', '/') + ":1.0");
            binding.addExtensibilityElement((ExtensibilityElement)bindingType);
        }
        catch (WSDLException ex) {
            throw new RuntimeException(ex);
        }
        binding.setUndefined(false);
        this.rootDefinition.addBinding(binding);
        return binding;
    }

    private boolean queryBinding(QName bqname) {
        Map bindings = this.definition.getBindings();
        for (Binding binding : bindings.values()) {
            if (!binding.getQName().getLocalPart().equals(bqname.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    private AST visitInterfaceInheritanceSpec(AST interfaceInheritanceSpecNode, Binding binding, Scope childScope) {
        BindingType corbaBinding = this.findCorbaBinding(binding);
        ArrayList<Scope> inheritedScopes = new ArrayList<Scope>();
        for (AST interfaceNameNode = interfaceInheritanceSpecNode.getFirstChild(); interfaceNameNode != null; interfaceNameNode = interfaceNameNode.getNextSibling()) {
            Scope interfaceScope = null;
            PortType intf = null;
            if (ScopedNameVisitor.isFullyScopedName(interfaceNameNode)) {
                interfaceScope = ScopedNameVisitor.getFullyScopedName(new Scope(), interfaceNameNode);
                intf = this.findPortType(interfaceScope);
            }
            for (Scope currentScope = this.getScope(); intf == null && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                interfaceScope = ScopedNameVisitor.isFullyScopedName(interfaceNameNode) ? ScopedNameVisitor.getFullyScopedName(currentScope, interfaceNameNode) : new Scope(currentScope, interfaceNameNode.toString());
                intf = this.findPortType(interfaceScope);
            }
            if (intf == null) {
                interfaceScope = ScopedNameVisitor.isFullyScopedName(interfaceNameNode) ? ScopedNameVisitor.getFullyScopedName(new Scope(), interfaceNameNode) : new Scope(new Scope(), interfaceNameNode);
                intf = this.findPortType(interfaceScope);
            }
            if (intf == null) {
                throw new RuntimeException("[InterfaceVisitor] Unknown Interface: " + interfaceNameNode.toString());
            }
            Scope defnScope = interfaceScope.getParent();
            Definition defn = this.manager.getWSDLDefinition(this.mapper.map(defnScope));
            inheritedScopes.add(interfaceScope);
            if (defn != null && !defn.getTargetNamespace().equals(this.definition.getTargetNamespace())) {
                String key = defnScope.toString("_");
                String fileName = this.getWsdlVisitor().getOutputDir() + System.getProperty("file.separator") + key;
                this.manager.addWSDLDefinitionImport(this.definition, defn, key, fileName);
            }
            Binding inheritedBinding = this.findBinding(intf);
            BindingType inheritedCorbaBinding = this.findCorbaBinding(inheritedBinding);
            corbaBinding.getBases().add(inheritedCorbaBinding.getRepositoryID());
            for (Operation op : CastUtils.cast(intf.getOperations(), Operation.class)) {
                String inputNS = op.getInput().getMessage().getQName().getNamespaceURI();
                this.manager.addWSDLDefinitionNamespace(this.definition, this.mapper.mapNSToPrefix(inputNS), inputNS);
                if (this.definition.getImports().get(inputNS) == null && !this.mapper.isDefaultMapping() && !this.definition.getTargetNamespace().equals(inputNS)) {
                    this.manager.addWSDLDefinitionImport(this.definition, this.manager.getWSDLDefinition(inputNS), this.mapper.mapNSToPrefix(inputNS), this.manager.getImportedWSDLDefinitionFile(inputNS));
                }
                String outputNS = op.getOutput().getMessage().getQName().getNamespaceURI();
                this.manager.addWSDLDefinitionNamespace(this.definition, this.mapper.mapNSToPrefix(outputNS), outputNS);
                if (this.definition.getImports().get(outputNS) == null && !this.mapper.isDefaultMapping() && !this.definition.getTargetNamespace().equals(outputNS)) {
                    this.manager.addWSDLDefinitionImport(this.definition, this.manager.getWSDLDefinition(outputNS), this.mapper.mapNSToPrefix(outputNS), this.manager.getImportedWSDLDefinitionFile(outputNS));
                }
                Iterator faults = CastUtils.cast(op.getFaults().values().iterator());
                while (faults.hasNext()) {
                    String faultNS = ((Fault)faults.next()).getMessage().getQName().getNamespaceURI();
                    this.manager.addWSDLDefinitionNamespace(this.definition, this.mapper.mapNSToPrefix(faultNS), faultNS);
                    if (this.definition.getImports().get(faultNS) != null || this.mapper.isDefaultMapping() || this.definition.getTargetNamespace().equals(faultNS)) continue;
                    this.manager.addWSDLDefinitionImport(this.definition, this.manager.getWSDLDefinition(faultNS), this.mapper.mapNSToPrefix(faultNS), this.manager.getImportedWSDLDefinitionFile(faultNS));
                }
                this.portType.addOperation(op);
            }
            Iterator it = CastUtils.cast(inheritedBinding.getBindingOperations().iterator());
            while (it.hasNext()) {
                binding.addBindingOperation((BindingOperation)it.next());
            }
        }
        if (!inheritedScopes.isEmpty() && this.wsdlVisitor.getInheritedScopeMap() != null) {
            this.wsdlVisitor.getInheritedScopeMap().put(childScope, inheritedScopes);
        }
        return interfaceInheritanceSpecNode.getNextSibling();
    }

    private void visitForwardDeclaredInterface(AST identifierNode) {
        String interfaceName = identifierNode.toString();
        Scope interfaceScope = new Scope(this.getScope(), interfaceName);
        ScopeNameCollection scopedNames = this.wsdlVisitor.getScopedNames();
        if (scopedNames.getScope(interfaceScope) == null) {
            scopedNames.add(interfaceScope);
        }
    }

    private PortType findPortType(Scope intfScope) {
        String tns = this.mapper.map(intfScope.getParent());
        String intfName = intfScope.toString();
        Definition defn = this.definition;
        if (tns != null) {
            defn = this.manager.getWSDLDefinition(tns);
            intfName = intfScope.tail();
        }
        if (defn != null) {
            tns = defn.getTargetNamespace();
            QName name = new QName(tns, intfName);
            return defn.getPortType(name);
        }
        return null;
    }

    private Binding findBinding(PortType intf) {
        Object[] bindings = this.rootDefinition.getBindings().values().toArray();
        for (int i = 0; i < bindings.length; ++i) {
            Binding binding = (Binding)bindings[i];
            if (!binding.getPortType().getQName().equals(intf.getQName())) continue;
            return binding;
        }
        throw new RuntimeException("[InterfaceVisitor] Couldn't find binding for porttype " + intf.getQName());
    }

    private BindingType findCorbaBinding(Binding binding) {
        List list = binding.getExtensibilityElements();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof BindingType)) continue;
            return (BindingType)list.get(i);
        }
        throw new RuntimeException("[InterfaceVisitor] Couldn't find Corba binding in Binding " + binding.getQName());
    }
}

