/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.ts;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxb.JAXBToStringBuilder;
import org.apache.cxf.jaxb.JAXBToStringStyle;
import org.xml.sax.ErrorHandler;

public class ToStringPlugin {
    private static final Logger LOG = LogUtils.getL7dLogger(ToStringPlugin.class);
    private String styleFieldName = "DEFAULT_STYLE";

    public String getOptionName() {
        return "Xts";
    }

    public String getUsage() {
        return "  -Xts                 : Activate plugin to add a toString() method to generated classes\n  -Xts:style:multiline : Have toString produce multi line output\n  -Xts:style:simple    : Have toString produce single line terse output\n";
    }

    public int parseArgument(Options opt, String[] args, int index, Plugin plugin) throws BadCommandLineException, IOException {
        int ret = 0;
        if (args[index].equals("-Xts:style:multiline")) {
            this.styleFieldName = "MULTI_LINE_STYLE";
            ret = 1;
        } else if (args[index].equals("-Xts:style:simple")) {
            this.styleFieldName = "SIMPLE_STYLE";
            ret = 1;
        }
        if (!opt.activePlugins.contains(plugin)) {
            opt.activePlugins.add(plugin);
        }
        return ret;
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        LOG.fine("Running toString() plugin.");
        JClass toStringDelegateImpl = outline.getCodeModel().ref(JAXBToStringBuilder.class);
        JClass styleClass = outline.getCodeModel().ref(JAXBToStringStyle.class);
        JFieldRef toStringDelegateStyleParam = styleClass.staticRef(this.styleFieldName);
        for (ClassOutline co : outline.getClasses()) {
            this.addToStringMethod(co, toStringDelegateImpl, toStringDelegateStyleParam);
        }
        return true;
    }

    private void addToStringMethod(ClassOutline co, JClass delegateImpl, JFieldRef toStringDelegateStyleParam) {
        JDefinedClass implementation = co.implClass;
        JMethod toStringMethod = implementation.method(1, String.class, "toString");
        JInvocation invoke = delegateImpl.staticInvoke("valueOf");
        invoke.arg(JExpr._this());
        invoke.arg((JExpression)toStringDelegateStyleParam);
        toStringMethod.body()._return((JExpression)invoke);
        JDocComment doc = toStringMethod.javadoc();
        doc.add((Object)"Generates a String representation of the contents of this type.");
        doc.add((Object)"\nThis is an extension method, produced by the 'ts' xjc plugin");
        toStringMethod.annotate(Override.class);
    }
}

