/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.abdera.ext.json.JSONUtil;
import org.apache.abdera.model.Base;
import org.apache.abdera.util.AbstractNamedWriter;
import org.apache.abdera.util.AbstractWriterOptions;
import org.apache.abdera.writer.NamedWriter;
import org.apache.abdera.writer.WriterOptions;

public class JSONWriter
extends AbstractNamedWriter
implements NamedWriter {
    public static final String NAME = "json";
    public static final String[] FORMATS = new String[]{"application/json", "application/javascript", "application/ecmascript", "text/javascript", "text/ecmascript"};

    public JSONWriter() {
        super(NAME, FORMATS);
    }

    protected WriterOptions initDefaultWriterOptions() {
        return new AbstractWriterOptions(){};
    }

    public String getName() {
        return NAME;
    }

    public Object write(Base base, WriterOptions options) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeTo(base, out, options);
            return new String(out.toByteArray(), options.getCharset());
        }
        catch (IOException i) {
            throw i;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void writeTo(Base base, OutputStream out, WriterOptions options) throws IOException {
        this.writeTo(base, new OutputStreamWriter(out, options.getCharset()), options);
    }

    public void writeTo(Base base, Writer out, WriterOptions options) throws IOException {
        try {
            JSONUtil.toJson(base, out);
            if (options.getAutoClose()) {
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

