/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.util.WebUtils;

public class ServletRequestAttributes
extends AbstractRequestAttributes {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = ServletRequestAttributes.class.getName() + ".DESTRUCTION_CALLBACK.";
    private final HttpServletRequest request;
    private volatile HttpSession session;
    private final Map sessionAttributesToUpdate = new HashMap();

    public ServletRequestAttributes(HttpServletRequest request) {
        Assert.notNull(request, "Request must not be null");
        this.request = request;
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    protected final HttpSession getSession(boolean allowCreate) {
        if (this.isRequestActive()) {
            return this.request.getSession(allowCreate);
        }
        if (this.session == null && allowCreate) {
            throw new IllegalStateException("No session found and request already completed - cannot create new session!");
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attribute - request is not active anymore!");
            }
            return this.request.getAttribute(name);
        }
        HttpSession session = this.getSession(false);
        if (session != null) {
            try {
                Object value = session.getAttribute(name);
                if (value != null) {
                    Map map = this.sessionAttributesToUpdate;
                    synchronized (map) {
                        this.sessionAttributesToUpdate.put(name, value);
                    }
                }
                return value;
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot set request attribute - request is not active anymore!");
            }
            this.request.setAttribute(name, value);
        } else {
            HttpSession session = this.getSession(true);
            Map map = this.sessionAttributesToUpdate;
            synchronized (map) {
                this.sessionAttributesToUpdate.remove(name);
            }
            session.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name, int scope) {
        if (scope == 0) {
            if (this.isRequestActive()) {
                this.request.removeAttribute(name);
                this.removeRequestDestructionCallback(name);
            }
        } else {
            HttpSession session = this.getSession(false);
            if (session != null) {
                Map map = this.sessionAttributesToUpdate;
                synchronized (map) {
                    this.sessionAttributesToUpdate.remove(name);
                }
                try {
                    session.removeAttribute(name);
                    session.removeAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name);
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
            }
        }
    }

    public String[] getAttributeNames(int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attributes - request is not active anymore!");
            }
            return StringUtils.toStringArray(this.request.getAttributeNames());
        }
        HttpSession session = this.getSession(false);
        if (session != null) {
            try {
                return StringUtils.toStringArray(session.getAttributeNames());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return new String[0];
    }

    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        if (scope == 0) {
            this.registerRequestDestructionCallback(name, callback);
        } else {
            this.registerSessionDestructionCallback(name, callback);
        }
    }

    public String getSessionId() {
        return this.getSession(true).getId();
    }

    public Object getSessionMutex() {
        return WebUtils.getSessionMutex(this.getSession(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAccessedSessionAttributes() {
        this.session = this.request.getSession(false);
        Map map = this.sessionAttributesToUpdate;
        synchronized (map) {
            if (this.session != null) {
                try {
                    Iterator it = this.sessionAttributesToUpdate.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String name = (String)entry.getKey();
                        Object newValue = entry.getValue();
                        Object oldValue = this.session.getAttribute(name);
                        if (oldValue != newValue) continue;
                        this.session.setAttribute(name, newValue);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            this.sessionAttributesToUpdate.clear();
        }
    }

    private void registerSessionDestructionCallback(String name, Runnable callback) {
        HttpSession session = this.getSession(true);
        session.setAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name, (Object)new DestructionCallbackBindingListener(callback));
    }

    public String toString() {
        return this.request.toString();
    }

    private static class DestructionCallbackBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private final Runnable destructionCallback;

        public DestructionCallbackBindingListener(Runnable destructionCallback) {
            this.destructionCallback = destructionCallback;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            this.destructionCallback.run();
        }
    }
}

