/*
 * Decompiled with CFR 0.152.
 */
package com.iona.cxf.container.util;

import com.iona.cxf.container.util.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public final class ApplicationExploder {
    private ApplicationExploder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File explodeApplication(File app, File repository) throws IOException {
        String dirName = app.getName();
        File appDir = new File(repository, dirName = dirName.substring(0, dirName.indexOf(".war")));
        if (appDir.exists()) {
            if (app.lastModified() > appDir.lastModified()) {
                boolean wasDeleted = ApplicationExploder.deleteFile(appDir);
                if (!wasDeleted) {
                    throw new IOException("Could not explode application. Existing directory could not be deleted: " + appDir);
                }
            } else {
                return appDir;
            }
        }
        appDir.mkdir();
        appDir.setLastModified(app.lastModified());
        FileInputStream istream = new FileInputStream(app);
        JarInputStream jstream = new JarInputStream(istream);
        try {
            ApplicationExploder.explodeJarFromStreamToDir(jstream, appDir);
        }
        finally {
            jstream.close();
        }
        return appDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void explodeJarFromStreamToDir(JarInputStream jstream, File parent) throws IOException {
        JarEntry entry = jstream.getNextJarEntry();
        while (entry != null) {
            String name = entry.getName();
            long size = entry.getSize();
            if (entry.isDirectory()) {
                File f = new File(parent, name);
                f.mkdirs();
            } else {
                int index = name.lastIndexOf(47);
                File f = new File(parent, name);
                if (index != -1) {
                    String dirName = name.substring(0, index);
                    File fp = new File(parent, dirName);
                    fp.mkdirs();
                }
                byte[] bytes = Utils.streamToByteArray(jstream, (int)size);
                if (name.endsWith(".jar")) {
                    ZipInputStream innerJarStream = null;
                    try {
                        f.mkdirs();
                        ByteArrayInputStream bstream = new ByteArrayInputStream(bytes);
                        innerJarStream = new JarInputStream(bstream);
                        ApplicationExploder.explodeJarFromStreamToDir((JarInputStream)innerJarStream, f);
                    }
                    finally {
                        innerJarStream.close();
                    }
                }
                OutputStream ostream = null;
                f.createNewFile();
                try {
                    ostream = new FileOutputStream(f);
                    ostream = new BufferedOutputStream(ostream);
                    ostream.write(bytes);
                }
                finally {
                    if (ostream != null) {
                        ostream.close();
                    }
                }
                long time = entry.getTime();
                f.setLastModified(time);
            }
            entry = jstream.getNextJarEntry();
        }
    }

    public static boolean deleteFile(File f) {
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                boolean deleted = ApplicationExploder.deleteFile(file);
                if (deleted) continue;
                return false;
            }
        }
        return f.delete();
    }
}

