/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import org.apache.cxf.Bus;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.interceptor.ServiceInvokerInterceptor;
import org.apache.cxf.service.Service;

public abstract class AbstractServiceFactoryBean {
    protected boolean dataBindingSet;
    private Bus bus;
    private DataBinding dataBinding;
    private Service service;

    public abstract Service create();

    protected void initializeDefaultInterceptors() {
        this.service.getInInterceptors().add(new ServiceInvokerInterceptor());
        this.service.getInInterceptors().add(new OutgoingChainInterceptor());
        this.service.getInInterceptors().add(new OneWayProcessorInterceptor());
    }

    protected void initializeDataBindings() {
        this.dataBinding.initialize(this.getService());
        this.service.setDataBinding(this.dataBinding);
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public DataBinding getDataBinding() {
        return this.getDataBinding(true);
    }

    public DataBinding getDataBinding(boolean create) {
        if (this.dataBinding == null && create) {
            this.dataBinding = this.createDefaultDataBinding();
        }
        return this.dataBinding;
    }

    protected DataBinding createDefaultDataBinding() {
        return null;
    }

    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
        this.dataBindingSet = dataBinding != null;
    }

    public Service getService() {
        return this.service;
    }

    protected void setService(Service service) {
        this.service = service;
    }
}

