/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationResourceInfo {
    private URITemplate uriTemplate;
    private ClassResourceInfo classResourceInfo;
    private Method methodToInvoke;
    private Method annotatedMethod;
    private String httpMethod;
    private List<MediaType> produceMimes;
    private List<MediaType> consumeMimes;
    private boolean encoded;
    private String defaultParamValue;
    private List<Parameter> parameters;

    public OperationResourceInfo(Method mInvoke, ClassResourceInfo cri) {
        this(mInvoke, mInvoke, cri);
    }

    OperationResourceInfo(OperationResourceInfo ori, ClassResourceInfo cri) {
        this.uriTemplate = ori.uriTemplate;
        this.methodToInvoke = ori.methodToInvoke;
        this.annotatedMethod = ori.annotatedMethod;
        this.httpMethod = ori.httpMethod;
        this.produceMimes = ori.produceMimes;
        this.consumeMimes = ori.consumeMimes;
        this.encoded = ori.encoded;
        this.defaultParamValue = ori.defaultParamValue;
        this.parameters = ori.parameters;
        this.classResourceInfo = cri;
    }

    public OperationResourceInfo(Method mInvoke, Method mAnnotated, ClassResourceInfo cri) {
        this.methodToInvoke = mInvoke;
        this.annotatedMethod = mAnnotated;
        if (mAnnotated != null) {
            this.parameters = ResourceUtils.getParameters(mAnnotated);
        }
        this.classResourceInfo = cri;
        this.checkMediaTypes(null, null);
        this.checkEncoded();
        this.checkDefaultParameterValue();
    }

    public OperationResourceInfo(Method m, ClassResourceInfo cri, URITemplate template, String httpVerb, String consumeMediaTypes, String produceMediaTypes, List<Parameter> params) {
        this.methodToInvoke = m;
        this.annotatedMethod = null;
        this.classResourceInfo = cri;
        this.uriTemplate = template;
        this.httpMethod = httpVerb;
        this.checkMediaTypes(consumeMediaTypes, produceMediaTypes);
        this.parameters = params;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public ClassResourceInfo getClassResourceInfo() {
        return this.classResourceInfo;
    }

    public Method getMethodToInvoke() {
        return this.methodToInvoke;
    }

    public Method getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    public void setMethodToInvoke(Method m) {
        this.methodToInvoke = m;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String m) {
        this.httpMethod = m;
    }

    public boolean isSubResourceLocator() {
        return this.httpMethod == null;
    }

    public List<MediaType> getProduceTypes() {
        return this.produceMimes;
    }

    public List<MediaType> getConsumeTypes() {
        return this.consumeMimes;
    }

    private void checkMediaTypes(String consumeMediaTypes, String produceMediaTypes) {
        if (consumeMediaTypes != null) {
            this.consumeMimes = JAXRSUtils.sortMediaTypes(consumeMediaTypes);
        } else {
            Consumes cm = AnnotationUtils.getMethodAnnotation(this.annotatedMethod, Consumes.class);
            if (cm != null) {
                this.consumeMimes = JAXRSUtils.sortMediaTypes(JAXRSUtils.getMediaTypes(cm.value()));
            } else if (this.classResourceInfo != null) {
                this.consumeMimes = JAXRSUtils.sortMediaTypes(this.classResourceInfo.getConsumeMime());
            }
        }
        if (produceMediaTypes != null) {
            this.produceMimes = JAXRSUtils.sortMediaTypes(produceMediaTypes);
        } else {
            Produces pm = AnnotationUtils.getMethodAnnotation(this.annotatedMethod, Produces.class);
            if (pm != null) {
                this.produceMimes = JAXRSUtils.sortMediaTypes(JAXRSUtils.getMediaTypes(pm.value()));
            } else if (this.classResourceInfo != null) {
                this.produceMimes = JAXRSUtils.sortMediaTypes(this.classResourceInfo.getProduceMime());
            }
        }
    }

    public boolean isEncodedEnabled() {
        return this.encoded;
    }

    public String getDefaultParameterValue() {
        return this.defaultParamValue;
    }

    private void checkEncoded() {
        boolean bl = this.encoded = AnnotationUtils.getMethodAnnotation(this.annotatedMethod, Encoded.class) != null;
        if (!this.encoded && this.classResourceInfo != null) {
            this.encoded = AnnotationUtils.getClassAnnotation(this.classResourceInfo.getServiceClass(), Encoded.class) != null;
        }
    }

    private void checkDefaultParameterValue() {
        DefaultValue dv = AnnotationUtils.getMethodAnnotation(this.annotatedMethod, DefaultValue.class);
        if (dv == null && this.classResourceInfo != null) {
            dv = AnnotationUtils.getClassAnnotation(this.classResourceInfo.getServiceClass(), DefaultValue.class);
        }
        if (dv != null) {
            this.defaultParamValue = dv.value();
        }
    }
}

