/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_osgi;

import java.io.IOException;
import java.net.URI;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPTransportFactory;
import org.apache.cxf.transport.http_osgi.OsgiDestination;
import org.apache.cxf.transport.http_osgi.OsgiDestinationRegistry;
import org.apache.cxf.transport.http_osgi.OsgiDestinationRegistryIntf;

public class OsgiTransportFactory
extends AbstractHTTPTransportFactory
implements DestinationFactory {
    private OsgiDestinationRegistryIntf registry;

    public void setRegistry(OsgiDestinationRegistryIntf registry) {
        this.registry = registry;
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        if (URI.create(endpointInfo.getAddress()).isAbsolute()) {
            throw new IllegalStateException("Endpoint address should be a relative URI wrt to the servlet address (use '/xxx' for example)");
        }
        OsgiDestination d = this.registry.getDestinationForPath(endpointInfo.getAddress());
        if (d == null) {
            String path = OsgiDestinationRegistry.getTrimmedPath(endpointInfo.getAddress());
            d = new OsgiDestination(this.getBus(), endpointInfo, this.registry, path);
            this.registry.addDestination(path, d);
        }
        return d;
    }

    public void init() {
    }
}

