/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_osgi;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http_osgi.OsgiDestinationRegistryIntf;

public class OsgiDestination
extends AbstractHTTPDestination {
    static final Logger LOG = LogUtils.getL7dLogger(OsgiDestination.class);
    private static final long serialVersionUID = 1L;
    final OsgiDestinationRegistryIntf factory;
    final String path;

    public OsgiDestination(Bus b, EndpointInfo ei, OsgiDestinationRegistryIntf fact, String p) throws IOException {
        super(b, null, ei, false);
        this.factory = fact;
        this.path = p;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Bus getBus() {
        return this.bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMessage(MessageImpl inMessage) throws IOException {
        try {
            this.setHeaders((Message)inMessage);
            inMessage.setDestination((Destination)this);
            this.incomingObserver.onMessage((Message)inMessage);
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    public void shutdown() {
        this.factory.removeDestination(this.path);
        super.shutdown();
    }
}

