/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.interceptor.WrappedInInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchemaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLiteralInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(DocLiteralInInterceptor.class);

    public DocLiteralInInterceptor() {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
        this.addBefore(WrappedInInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        if (this.isGET(message) && message.getContent(List.class) != null) {
            LOG.fine("DocLiteralInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        DataReader<XMLStreamReader> dr = this.getDataReader(message);
        MessageContentsList parameters = new MessageContentsList();
        Exchange exchange = message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        boolean client = this.isRequestor(message);
        if (bop != null && !StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            return;
        }
        if (bop != null && bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        if (bop == null) {
            QName startQName = xmlReader == null ? new QName("http://cxf.apache.org/jaxws/provider", "invoke") : xmlReader.getName();
            bop = this.getBindingOperationInfo(exchange, startQName, client);
        }
        try {
            if (bop != null && bop.isUnwrappedCapable()) {
                ServiceInfo si = bop.getBinding().getService();
                MessageInfo msgInfo = this.setMessage(message, bop, client, si);
                if (((MessagePartInfo)msgInfo.getMessageParts().get(0)).getTypeClass() != null) {
                    QName startQName = xmlReader.getName();
                    if (client && !((MessagePartInfo)msgInfo.getMessageParts().get(0)).getConcreteName().equals(startQName)) {
                        throw new Fault("UNEXPECTED_WRAPPER_ELEMENT", LOG, null, new Object[]{startQName, ((MessagePartInfo)msgInfo.getMessageParts().get(0)).getConcreteName()});
                    }
                    Object wrappedObject = dr.read((MessagePartInfo)msgInfo.getMessageParts().get(0), (Object)xmlReader);
                    parameters.put((MessagePartInfo)msgInfo.getMessageParts().get(0), wrappedObject);
                } else {
                    bop = bop.getUnwrappedOperation();
                    msgInfo = this.setMessage(message, bop, client, si);
                    List messageParts = msgInfo.getMessageParts();
                    Iterator<MessagePartInfo> itr = messageParts.iterator();
                    if (xmlReader.getEventType() == 1) {
                        StaxUtils.nextEvent((XMLStreamReader)xmlReader);
                    }
                    this.getPara(xmlReader, dr, parameters, itr, message);
                }
            } else {
                BindingMessageInfo msgInfo = null;
                Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
                ServiceInfo si = ep.getEndpointInfo().getService();
                if (bop != null) {
                    if (client) {
                        msgInfo = bop.getOutput();
                    } else {
                        msgInfo = bop.getInput();
                        if (bop.getOutput() == null) {
                            exchange.setOneWay(true);
                        }
                    }
                    if (msgInfo == null) {
                        return;
                    }
                    this.setMessage(message, bop, client, si, msgInfo.getMessageInfo());
                }
                ArrayList<OperationInfo> operations = null;
                operations = new ArrayList<OperationInfo>();
                operations.addAll(si.getInterface().getOperations());
                if (xmlReader == null || !StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
                    for (OperationInfo op : operations) {
                        MessageInfo bmsg = op.getInput();
                        if (bmsg.getMessageParts().size() != 0) continue;
                        BindingOperationInfo boi = ep.getEndpointInfo().getBinding().getOperation(op);
                        exchange.put(BindingOperationInfo.class, (Object)boi);
                        exchange.put(OperationInfo.class, (Object)op);
                        exchange.setOneWay(op.isOneWay());
                    }
                    return;
                }
                int paramNum = 0;
                do {
                    MessagePartInfo p;
                    QName elName = xmlReader.getName();
                    Object o = null;
                    if (!client && msgInfo != null && msgInfo.getMessageParts() != null && msgInfo.getMessageParts().size() == 0) {
                        return;
                    }
                    if (msgInfo != null && msgInfo.getMessageParts() != null && msgInfo.getMessageParts().size() > 0) {
                        assert (msgInfo.getMessageParts().size() > paramNum);
                        p = (MessagePartInfo)msgInfo.getMessageParts().get(paramNum);
                    } else {
                        p = this.findMessagePart(exchange, operations, elName, client, paramNum, message);
                    }
                    if (p == null) {
                        throw new Fault(new org.apache.cxf.common.i18n.Message("NO_PART_FOUND", LOG, new Object[]{elName}), Fault.FAULT_CODE_CLIENT);
                    }
                    o = dr.read(p, (Object)xmlReader);
                    parameters.put(p, o);
                    ++paramNum;
                    if (message.getContent(XMLStreamReader.class) != null && o != xmlReader) continue;
                    xmlReader = null;
                } while (xmlReader != null && StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader));
            }
            message.setContent(List.class, (Object)parameters);
        }
        catch (Fault f) {
            if (!this.isRequestor(message)) {
                f.setFaultCode(Fault.FAULT_CODE_CLIENT);
            }
            throw f;
        }
    }

    private void getPara(DepthXMLStreamReader xmlReader, DataReader<XMLStreamReader> dr, MessageContentsList parameters, Iterator<MessagePartInfo> itr, Message message) {
        boolean hasNext = true;
        while (itr.hasNext()) {
            MessagePartInfo part = itr.next();
            if (hasNext) {
                hasNext = StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader);
            }
            Object obj = null;
            if (hasNext) {
                QName rname = xmlReader.getName();
                while (part != null && !rname.equals(part.getConcreteName())) {
                    if (part.getXmlSchema() instanceof XmlSchemaElement) {
                        parameters.put(part, null);
                    }
                    if (itr.hasNext()) {
                        part = itr.next();
                        continue;
                    }
                    part = null;
                }
                if (part == null) {
                    return;
                }
                if (rname.equals(part.getConcreteName())) {
                    obj = dr.read(part, (Object)xmlReader);
                }
            }
            parameters.put(part, obj);
        }
    }

    private MessageInfo setMessage(Message message, BindingOperationInfo operation, boolean requestor, ServiceInfo si) {
        MessageInfo msgInfo = this.getMessageInfo(message, operation, requestor);
        return this.setMessage(message, operation, requestor, si, msgInfo);
    }

    @Override
    protected BindingOperationInfo getBindingOperationInfo(Exchange exchange, QName name, boolean client) {
        BindingOperationInfo bop = ServiceModelUtil.getOperationForWrapperElement((Exchange)exchange, (QName)name, (boolean)client);
        if (bop == null) {
            bop = super.getBindingOperationInfo(exchange, name, client);
        }
        if (bop != null) {
            exchange.put(BindingOperationInfo.class, (Object)bop);
            exchange.put(OperationInfo.class, (Object)bop.getOperationInfo());
        }
        return bop;
    }
}

