/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.bg;

import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.xml.sax.ErrorHandler;

public class BooleanGetterPlugin {
    private static final Logger LOG = LogUtils.getL7dLogger(BooleanGetterPlugin.class);

    public String getOptionName() {
        return "Xbg";
    }

    public String getUsage() {
        return "  -Xbg                 : Generate getters methods for Booleans";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        LOG.info("Running boolean getter plugin.");
        for (ClassOutline classOutline : outline.getClasses()) {
            Collection methods = classOutline.implClass.methods();
            for (JMethod method : methods) {
                if (!method.name().startsWith("is")) continue;
                String newName = "get" + method.name().substring(2);
                LOG.info("Changing method name from " + method.name() + " to " + newName);
                method.javadoc().add((Object)("\nThis getter has been renamed from " + method.name() + "() to " + newName + "() by cxf-xjc-boolean plugin."));
                method.name(newName);
            }
        }
        return true;
    }
}

