/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);

    public JAXRSOutInterceptor() {
        super("marshal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        try {
            this.processResponse(message);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Object rootInstance = message.getExchange().remove((Object)"service.root.instance");
            Object rootProvider = message.getExchange().remove((Object)"service.root.provider");
            if (rootInstance != null && rootProvider != null) {
                try {
                    ((ResourceProvider)rootProvider).releaseInstance(message, rootInstance);
                }
                catch (Throwable tex) {
                    LOG.warning("Exception occurred during releasing the service instance, " + tex.getMessage());
                }
            }
            ProviderFactory.getInstance(message).clearThreadLocalProxies();
            ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get((Object)"root.resource.class");
            if (cri != null) {
                cri.clearThreadLocalProxies();
            }
            throw throwable;
        }
        Object rootInstance = message.getExchange().remove((Object)"service.root.instance");
        Object rootProvider = message.getExchange().remove((Object)"service.root.provider");
        if (rootInstance != null && rootProvider != null) {
            try {
                ((ResourceProvider)rootProvider).releaseInstance(message, rootInstance);
            }
            catch (Throwable tex) {
                LOG.warning("Exception occurred during releasing the service instance, " + tex.getMessage());
            }
        }
        ProviderFactory.getInstance(message).clearThreadLocalProxies();
        ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get((Object)"root.resource.class");
        if (cri != null) {
            cri.clearThreadLocalProxies();
        }
    }

    private void processResponse(Message message) {
        if (this.isResponseAlreadyHandled(message)) {
            return;
        }
        MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        if (objs.get(0) != null) {
            Object responseObj = objs.get(0);
            Response response = null;
            if (objs.get(0) instanceof Response) {
                response = (Response)responseObj;
            } else {
                int status = this.getStatus(message, 200);
                response = Response.status((int)status).entity(responseObj).build();
            }
            Exchange exchange = message.getExchange();
            OperationResourceInfo ori = (OperationResourceInfo)exchange.get((Object)OperationResourceInfo.class.getName());
            List<ProviderInfo<ResponseHandler>> handlers = ProviderFactory.getInstance(message).getResponseHandlers();
            for (ProviderInfo<ResponseHandler> rh : handlers) {
                InjectionUtils.injectContextFields(rh.getProvider(), rh, message.getExchange().getInMessage());
                InjectionUtils.injectContextFields(rh.getProvider(), rh, message.getExchange().getInMessage());
                Response r = rh.getProvider().handleResponse(message, ori, response);
                if (r == null) continue;
                response = r;
            }
            this.serializeMessage(message, response, ori, true);
        } else {
            int status = this.getStatus(message, 204);
            message.put((Object)Message.RESPONSE_CODE, (Object)status);
        }
    }

    private int getStatus(Message message, int defaultValue) {
        Object customStatus = message.getExchange().get((Object)Message.RESPONSE_CODE);
        return customStatus == null ? defaultValue : (Integer)customStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serializeMessage(Message message, Response response, OperationResourceInfo ori, boolean firstTry) {
        boolean ignoreWriters;
        int status = response.getStatus();
        Object responseObj = response.getEntity();
        if (status == 200 && !this.isResponseNull(responseObj) && firstTry && ori != null && JAXRSUtils.headMethodPossible(ori.getHttpMethod(), (String)message.getExchange().getInMessage().get((Object)Message.HTTP_REQUEST_METHOD))) {
            LOG.info(new org.apache.cxf.common.i18n.Message("HEAD_WITHOUT_ENTITY", BUNDLE, new Object[0]).toString());
            responseObj = null;
        }
        if (status == -1) {
            status = this.isResponseNull(responseObj) ? 204 : 200;
        }
        message.put((Object)Message.RESPONSE_CODE, (Object)status);
        Map theHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (firstTry && theHeaders != null) {
            theHeaders.putAll(response.getMetadata());
        } else {
            message.put((Object)Message.PROTOCOL_HEADERS, (Object)response.getMetadata());
        }
        MultivaluedMap responseHeaders = (MultivaluedMap)message.get((Object)Message.PROTOCOL_HEADERS);
        this.setResponseDate((MultivaluedMap<String, Object>)responseHeaders, firstTry);
        if (this.isResponseNull(responseObj)) {
            return;
        }
        Object ignoreWritersProp = message.getExchange().get((Object)"ignore.message.writers");
        boolean bl = ignoreWriters = ignoreWritersProp == null ? false : Boolean.valueOf(ignoreWritersProp.toString());
        if (ignoreWriters) {
            this.writeResponseToStream((OutputStream)message.getContent(OutputStream.class), responseObj);
            return;
        }
        List<MediaType> availableContentTypes = this.computeAvailableContentTypes(message, response);
        Method invoked = null;
        if (firstTry) {
            invoked = ori == null ? null : ori.getMethodToInvoke();
        }
        Class<?> targetType = this.getRawResponseClass(responseObj);
        Type genericType = this.getGenericResponseType(ori == null ? null : ori.getAnnotatedMethod(), responseObj);
        if (genericType instanceof TypeVariable) {
            genericType = InjectionUtils.getSuperType(ori.getClassResourceInfo().getServiceClass(), (TypeVariable)genericType);
        }
        MessageBodyWriter<?> writer = null;
        MediaType responseType = null;
        for (MediaType type : availableContentTypes) {
            writer = ProviderFactory.getInstance(message).createMessageBodyWriter(targetType, genericType, invoked != null ? invoked.getAnnotations() : new Annotation[]{}, type, message);
            if (writer == null) continue;
            responseType = type;
            break;
        }
        OutputStream outOriginal = (OutputStream)message.getContent(OutputStream.class);
        if (writer == null) {
            message.put((Object)"Content-Type", (Object)"text/plain");
            message.put((Object)Message.RESPONSE_CODE, (Object)500);
            this.writeResponseErrorMessage(outOriginal, "NO_MSG_WRITER", targetType.getSimpleName());
            return;
        }
        boolean enabled = this.checkBufferingMode(message, writer, firstTry);
        Object entity = this.getEntity(responseObj);
        try {
            block18: {
                block17: {
                    responseType = this.checkFinalContentType(responseType);
                    LOG.fine("Response content type is: " + responseType.toString());
                    message.put((Object)"Content-Type", (Object)responseType.toString());
                    LOG.fine("Response EntityProvider is: " + writer.getClass().getName());
                    try {
                        writer.writeTo(entity, targetType, genericType, invoked != null ? invoked.getAnnotations() : new Annotation[]{}, responseType, responseHeaders, (OutputStream)message.getContent(OutputStream.class));
                        if (this.isResponseRedirected(message)) {
                            Object var22_21 = null;
                            if (!enabled) return;
                            break block17;
                        }
                        Object newContentType = responseHeaders.getFirst((Object)"Content-Type");
                        if (newContentType != null) {
                            message.put((Object)"Content-Type", (Object)newContentType.toString());
                        }
                        this.checkCachedStream(message, outOriginal, enabled);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var22_23 = null;
                        if (!enabled) throw throwable;
                        message.setContent(OutputStream.class, (Object)outOriginal);
                        message.put((Object)XMLStreamWriter.class.getName(), null);
                        throw throwable;
                    }
                }
                message.setContent(OutputStream.class, (Object)outOriginal);
                message.put((Object)XMLStreamWriter.class.getName(), null);
                return;
            }
            Object var22_22 = null;
            if (!enabled) return;
            message.setContent(OutputStream.class, (Object)outOriginal);
            message.put((Object)XMLStreamWriter.class.getName(), null);
            return;
        }
        catch (IOException ex) {
            this.handleWriteException(message, response, ori, ex, entity, firstTry);
            return;
        }
        catch (Throwable ex) {
            this.handleWriteException(message, response, ori, ex, entity, firstTry);
        }
    }

    private boolean isResponseNull(Object o) {
        return o == null || GenericEntity.class.isAssignableFrom(o.getClass()) && ((GenericEntity)o).getEntity() == null;
    }

    private Object getEntity(Object o) {
        return GenericEntity.class.isAssignableFrom(o.getClass()) ? ((GenericEntity)o).getEntity() : o;
    }

    private boolean checkBufferingMode(Message m, MessageBodyWriter w, boolean firstTry) {
        boolean enabled;
        if (!firstTry) {
            return false;
        }
        Object outBuf = m.getContextualProperty("org.apache.cxf.output.buffering");
        boolean bl = enabled = Boolean.TRUE.equals(outBuf) || "true".equals(outBuf);
        if (!enabled && outBuf == null) {
            enabled = InjectionUtils.invokeBooleanGetter(w, "getEnableBuffering");
        }
        if (enabled) {
            boolean streamingOn = InjectionUtils.invokeBooleanGetter(w, "getEnableStreaming");
            if (streamingOn) {
                m.setContent(XMLStreamWriter.class, (Object)new CachingXmlEventWriter());
            } else {
                m.setContent(OutputStream.class, (Object)new CachedOutputStream());
            }
        }
        return enabled;
    }

    private void checkCachedStream(Message m, OutputStream osOriginal, boolean enabled) throws Exception {
        CachedOutputStream cos;
        OutputStream os;
        XMLStreamWriter writer = null;
        writer = enabled ? (XMLStreamWriter)m.getContent(XMLStreamWriter.class) : (XMLStreamWriter)m.get((Object)XMLStreamWriter.class.getName());
        if (writer instanceof CachingXmlEventWriter) {
            CachingXmlEventWriter cache = (CachingXmlEventWriter)writer;
            if (cache.getEvents().size() != 0) {
                XMLStreamWriter origWriter = StaxUtils.createXMLStreamWriter((OutputStream)osOriginal);
                for (XMLEvent event : cache.getEvents()) {
                    StaxUtils.writeEvent((XMLEvent)event, (XMLStreamWriter)origWriter);
                }
            }
            m.setContent(XMLStreamWriter.class, null);
            return;
        }
        if (enabled && (os = (OutputStream)m.getContent(OutputStream.class)) != osOriginal && os instanceof CachedOutputStream && (cos = (CachedOutputStream)os).size() != 0) {
            cos.writeCacheTo(osOriginal);
        }
    }

    private void handleWriteException(Message message, Response response, OperationResourceInfo ori, Throwable ex, Object responseObj, boolean firstTry) {
        OutputStream out = (OutputStream)message.getContent(OutputStream.class);
        if (firstTry) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
            if (excResponse != null) {
                this.serializeMessage(message, excResponse, ori, false);
            }
        } else {
            message.put((Object)Message.RESPONSE_CODE, (Object)500);
            this.writeResponseErrorMessage(out, "SERIALIZE_ERROR", responseObj.getClass().getSimpleName());
        }
    }

    private void writeResponseErrorMessage(OutputStream out, String errorString, String parameter) {
        try {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message(errorString, BUNDLE, new Object[]{parameter});
            LOG.warning(message.toString());
            out.write(message.toString().getBytes("UTF-8"));
        }
        catch (IOException another) {
            // empty catch block
        }
    }

    private List<MediaType> computeAvailableContentTypes(Message message, Response response) {
        Object contentType = response.getMetadata().getFirst((Object)"Content-Type");
        Exchange exchange = message.getExchange();
        List<MediaType> produceTypes = null;
        OperationResourceInfo operation = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        if (contentType != null) {
            return Collections.singletonList(MediaType.valueOf((String)contentType.toString()));
        }
        produceTypes = operation != null ? operation.getProduceTypes() : Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        List<MediaType> acceptContentTypes = (List<MediaType>)exchange.get((Object)"Accept");
        if (acceptContentTypes == null) {
            acceptContentTypes = Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        return JAXRSUtils.intersectMimeTypes(acceptContentTypes, produceTypes);
    }

    private Class<?> getRawResponseClass(Object targetObject) {
        if (GenericEntity.class.isAssignableFrom(targetObject.getClass())) {
            return ((GenericEntity)targetObject).getRawType();
        }
        return targetObject.getClass();
    }

    private Type getGenericResponseType(Method invoked, Object targetObject) {
        if (GenericEntity.class.isAssignableFrom(targetObject.getClass())) {
            return ((GenericEntity)targetObject).getType();
        }
        return invoked == null ? targetObject.getClass() : invoked.getGenericReturnType();
    }

    private MediaType checkFinalContentType(MediaType mt) {
        if (mt.isWildcardType() || mt.isWildcardSubtype()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if (mt.getParameters().containsKey("q")) {
            return MediaType.valueOf((String)JAXRSUtils.removeMediaTypeParameter(mt, "q"));
        }
        return mt;
    }

    private void setResponseDate(MultivaluedMap<String, Object> headers, boolean firstTry) {
        if (!firstTry) {
            return;
        }
        SimpleDateFormat format = HttpUtils.getHttpDateFormat();
        headers.putSingle((Object)"Date", (Object)format.format(new Date()));
    }

    private boolean isResponseAlreadyHandled(Message m) {
        return this.isResponseAlreadyCommited(m) || this.isResponseRedirected(m);
    }

    private boolean isResponseAlreadyCommited(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get((Object)"http.response.done"));
    }

    private boolean isResponseRedirected(Message outMessage) {
        return Boolean.TRUE.equals(outMessage.get((Object)"http.request.redirected"));
    }

    private void writeResponseToStream(OutputStream os, Object responseObj) {
        try {
            byte[] bytes = responseObj.toString().getBytes("UTF-8");
            os.write(bytes, 0, bytes.length);
        }
        catch (Exception ex) {
            LOG.severe("Problem with writing the data to the output stream");
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

