/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.cxf.helpers.CastUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoStageMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_EDEN_CAPACITY = 50;
    private final int edenCapacity;
    private Map<K, V> eden;
    private List<K> edenKeys;
    private Map<K, V> aged;

    public TwoStageMap() {
        this(50);
    }

    public TwoStageMap(int c) {
        this.edenCapacity = c;
        this.eden = new HashMap(this.edenCapacity);
        this.edenKeys = new ArrayList<K>(this.edenCapacity);
        this.aged = new WeakHashMap();
    }

    @Override
    public synchronized int size() {
        return this.eden.size() + this.aged.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.eden.isEmpty() && this.aged.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.eden.containsKey(key) || this.aged.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.eden.containsValue(value) || this.aged.containsValue(value);
    }

    @Override
    public synchronized V get(Object key) {
        V edenValue = this.eden.get(key);
        return edenValue != null ? edenValue : this.aged.get(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        if (this.eden.size() >= this.edenCapacity) {
            K victimKey = this.edenKeys.remove(0);
            this.aged.put(victimKey, this.eden.remove(victimKey));
        }
        this.edenKeys.add(key);
        return this.eden.put(key, value);
    }

    @Override
    public synchronized V remove(Object key) {
        V victim = null;
        if (this.eden.containsKey(key)) {
            this.edenKeys.remove(key);
            victim = this.eden.remove(key);
        } else {
            victim = this.aged.remove(key);
        }
        return victim;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        Set<Map.Entry> entries = CastUtils.cast(t.entrySet());
        for (Map.Entry entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        this.eden.clear();
        this.edenKeys.clear();
        this.aged.clear();
    }

    @Override
    public synchronized Set<K> keySet() {
        Set<K> keys = this.eden.keySet();
        keys.addAll(this.aged.keySet());
        return keys;
    }

    @Override
    public synchronized Collection<V> values() {
        Collection<V> values = this.eden.values();
        values.addAll(this.aged.values());
        return values;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> entries = this.eden.entrySet();
        entries.addAll(this.aged.entrySet());
        return entries;
    }
}

