/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.wsdl.OperationType;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSParameter;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WebParamAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.XmlJavaTypeAdapterAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.XmlListAnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper.ParameterMapper;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.constants.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterProcessor
extends AbstractProcessor {
    public static final String HEADER = "messagepart.isheader";
    public static final String OUT_OF_BAND_HEADER = "messagepart.is_out_of_band_header";
    private DataBindingProfile dataBinding;

    public ParameterProcessor(ToolContext penv) {
        super(penv);
        this.dataBinding = this.context.get(DataBindingProfile.class);
    }

    private boolean isRequestResponse(JavaMethod method) {
        return method.getStyle() == OperationType.REQUEST_RESPONSE;
    }

    public void process(JavaMethod method, MessageInfo inputMessage, MessageInfo outputMessage, List<String> parameterOrder) throws ToolException {
        if (!StringUtils.isEmpty(parameterOrder) && this.isValidOrdering(parameterOrder, inputMessage, outputMessage) && !method.isWrapperStyle()) {
            this.buildParamModelsWithOrdering(method, inputMessage, outputMessage, parameterOrder);
        } else {
            this.buildParamModelsWithoutOrdering(method, inputMessage, outputMessage);
        }
    }

    public JavaParameter addParameterFromBinding(JavaMethod method, MessagePartInfo part, JavaType.Style style) throws ToolException {
        return this.addParameter(method, this.getParameterFromPart(method, part, style));
    }

    private JavaParameter getParameterFromPart(JavaMethod jm, MessagePartInfo part, JavaType.Style style) {
        return ParameterMapper.map(jm, part, style, this.context);
    }

    protected JavaParameter addParameter(JavaMethod method, JavaParameter parameter) throws ToolException {
        if (parameter == null) {
            return null;
        }
        String name = parameter.getName();
        int count = 0;
        while (method.getParameter(parameter.getName()) != null && this.context.optionSet("autoNameResolution") && parameter.getStyle() != JavaType.Style.INOUT) {
            parameter.setName(name + ++count);
        }
        parameter.setMethod(method);
        parameter.annotate(new WebParamAnnotator());
        method.addParameter(parameter);
        return parameter;
    }

    private void processReturn(JavaMethod method, MessagePartInfo part) {
        XmlSchemaElement element;
        String name = part == null ? "return" : part.getName().getLocalPart();
        String type = part == null ? "void" : ProcessorUtil.resolvePartType(part, this.context);
        String namespace = part == null ? null : ProcessorUtil.resolvePartNamespace(part);
        JavaReturn returnType = new JavaReturn(name, type, namespace);
        if (part != null) {
            returnType.setDefaultValueWriter(ProcessorUtil.getDefaultValueWriter(part, this.context));
        }
        returnType.setQName(ProcessorUtil.getElementName(part));
        returnType.setStyle(JavaType.Style.OUT);
        if (namespace != null && type != null && !"void".equals(type)) {
            returnType.setClassName(ProcessorUtil.getFullClzName(part, this.context, false));
        }
        if (part != null && part.getXmlSchema() instanceof XmlSchemaSimpleType) {
            ParameterProcessor.processXmlSchemaSimpleType((XmlSchemaSimpleType)part.getXmlSchema(), method, part);
        } else if (part != null && part.getXmlSchema() instanceof XmlSchemaElement && (element = (XmlSchemaElement)part.getXmlSchema()).getSchemaType() instanceof XmlSchemaSimpleType) {
            ParameterProcessor.processXmlSchemaSimpleType((XmlSchemaSimpleType)element.getSchemaType(), method, part);
        }
        method.setReturn(returnType);
    }

    private static void processXmlSchemaSimpleType(XmlSchemaSimpleType xmlSchema, JavaMethod method, MessagePartInfo part) {
        if (!(!(xmlSchema.getContent() instanceof XmlSchemaSimpleTypeList) || part.isElement() && method.isWrapperStyle())) {
            method.annotate(new XmlListAnotator(method.getInterface()));
        }
        if (!(!Constants.XSD_HEXBIN.equals(xmlSchema.getQName()) || part.isElement() && method.isWrapperStyle())) {
            method.annotate(new XmlJavaTypeAdapterAnnotator(method.getInterface(), HexBinaryAdapter.class));
        }
    }

    private boolean isOutOfBandHeader(MessagePartInfo part) {
        return Boolean.TRUE.equals(part.getProperty(OUT_OF_BAND_HEADER));
    }

    private boolean requireOutOfBandHeader() {
        String value = (String)this.context.get("exsoapheader");
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private int countOutOfBandHeader(MessageInfo message) {
        int count = 0;
        for (MessagePartInfo part : message.getMessageParts()) {
            if (!this.isOutOfBandHeader(part)) continue;
            ++count;
        }
        return count;
    }

    private boolean messagePartsNotUnique(MessageInfo message) {
        int count = this.countOutOfBandHeader(message);
        return message.getMessageParts().size() - count > 1;
    }

    private void processInput(JavaMethod method, MessageInfo inputMessage) throws ToolException {
        if (this.requireOutOfBandHeader()) {
            try {
                Class.forName("org.apache.cxf.binding.soap.SoapBindingFactory");
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, new Message("SOAP_MISSING", LOG, new Object[0]).toString());
            }
        }
        JAXWSBinding mBinding = inputMessage.getOperation().getExtensor(JAXWSBinding.class);
        for (MessagePartInfo part : inputMessage.getMessageParts()) {
            if (this.isOutOfBandHeader(part) && !this.requireOutOfBandHeader()) continue;
            JavaParameter param = this.getParameterFromPart(method, part, JavaType.Style.IN);
            if (mBinding != null && mBinding.getJaxwsParas() != null) {
                for (JAXWSParameter jwp : mBinding.getJaxwsParas()) {
                    if (!part.getName().getLocalPart().equals(jwp.getPart())) continue;
                    param.setName(jwp.getName());
                }
            }
            this.addParameter(method, param);
        }
    }

    private void processWrappedInput(JavaMethod method, MessageInfo inputMessage) throws ToolException {
        List<MessagePartInfo> inputParts = inputMessage.getMessageParts();
        if (this.messagePartsNotUnique(inputMessage)) {
            this.processInput(method, inputMessage);
            return;
        }
        if (inputParts.isEmpty()) {
            return;
        }
        MessagePartInfo part = inputParts.iterator().next();
        List<QName> wrappedElements = ProcessorUtil.getWrappedElementQNames(this.context, part.getElementQName());
        if ((wrappedElements == null || wrappedElements.size() == 0) && this.countOutOfBandHeader(inputMessage) == 0) {
            return;
        }
        JAXWSBinding mBinding = inputMessage.getOperation().getExtensor(JAXWSBinding.class);
        for (QName item : wrappedElements) {
            JavaParameter jp = this.getParameterFromQName(part.getElementQName(), item, JavaType.Style.IN, part);
            if (mBinding != null && mBinding.getJaxwsParas() != null) {
                for (JAXWSParameter jwsp : mBinding.getJaxwsParas()) {
                    if (!item.equals(jwsp.getElementName())) continue;
                    jp.setName(jwsp.getName());
                }
            }
            if (StringUtils.isEmpty(part.getConcreteName().getNamespaceURI())) {
                jp.setTargetNamespace("");
            }
            this.addParameter(method, jp);
        }
        if (this.requireOutOfBandHeader() && this.countOutOfBandHeader(inputMessage) > 0) {
            for (MessagePartInfo hpart : inputMessage.getMessageParts()) {
                if (!this.isOutOfBandHeader(hpart)) continue;
                this.addParameter(method, this.getParameterFromPart(method, hpart, JavaType.Style.IN));
            }
        }
    }

    private void processOutput(JavaMethod method, MessageInfo inputMessage, MessageInfo outputMessage) throws ToolException {
        Map<QName, MessagePartInfo> inputPartsMap = inputMessage.getMessagePartsMap();
        List<Object> outputParts = outputMessage == null ? new ArrayList() : outputMessage.getMessageParts();
        ArrayList<MessagePartInfo> outParts = new ArrayList<MessagePartInfo>();
        int numHeader = 0;
        if (this.isRequestResponse(method)) {
            for (MessagePartInfo messagePartInfo : outputParts) {
                MessagePartInfo inpart;
                boolean oob = false;
                if (this.isOutOfBandHeader(messagePartInfo)) {
                    if (!this.requireOutOfBandHeader()) continue;
                    oob = true;
                }
                if ((inpart = inputPartsMap.get(messagePartInfo.getName())) == null) {
                    outParts.add(messagePartInfo);
                    if (!oob) continue;
                    ++numHeader;
                    continue;
                }
                if (this.isSamePart(inpart, messagePartInfo)) {
                    boolean found = false;
                    for (JavaParameter p : method.getParameters()) {
                        if (!p.getQName().equals(ProcessorUtil.getElementName(messagePartInfo)) || !p.getPartName().equals(messagePartInfo.getName().getLocalPart())) continue;
                        p.setHolder(true);
                        p.setHolderName(Holder.class.getName());
                        String holderClass = p.getClassName();
                        if (JAXBUtils.holderClass(holderClass) != null) {
                            holderClass = JAXBUtils.holderClass(holderClass).getName();
                        }
                        p.setClassName(holderClass);
                        p.getAnnotations().clear();
                        p.setStyle(JavaType.Style.INOUT);
                        p.annotate(new WebParamAnnotator());
                        found = true;
                    }
                    if (found) continue;
                    this.addParameter(method, this.getParameterFromPart(method, messagePartInfo, JavaType.Style.INOUT));
                    continue;
                }
                if (this.isSamePart(inpart, messagePartInfo)) continue;
                if (oob) {
                    ++numHeader;
                }
                outParts.add(messagePartInfo);
            }
        }
        if (this.isRequestResponse(method)) {
            if (outParts.size() - numHeader == 1 && !this.isHeader((MessagePartInfo)outParts.get(0))) {
                this.processReturn(method, (MessagePartInfo)outParts.get(0));
                outParts.remove(0);
            } else {
                this.processReturn(method, null);
            }
            JAXWSBinding mBinding = outputMessage.getOperation().getExtensor(JAXWSBinding.class);
            for (MessagePartInfo part : outParts) {
                JavaParameter param = this.getParameterFromPart(method, part, JavaType.Style.OUT);
                if (mBinding != null && mBinding.getJaxwsParas() != null) {
                    for (JAXWSParameter jwp : mBinding.getJaxwsParas()) {
                        if (!part.getName().getLocalPart().equals(jwp.getPart())) continue;
                        param.setName(jwp.getName());
                    }
                }
                this.addParameter(method, param);
            }
        } else {
            this.processReturn(method, null);
        }
    }

    private void processWrappedOutput(JavaMethod method, MessageInfo inputMessage, MessageInfo outputMessage) throws ToolException {
        this.processWrappedAbstractOutput(method, inputMessage, outputMessage);
        if (this.countOutOfBandHeader(outputMessage) > 0) {
            for (MessagePartInfo hpart : outputMessage.getMessageParts()) {
                if (!this.isOutOfBandHeader(hpart) || !this.requireOutOfBandHeader()) continue;
                this.addParameter(method, this.getParameterFromPart(method, hpart, JavaType.Style.OUT));
            }
        }
    }

    private void processWrappedAbstractOutput(JavaMethod method, MessageInfo inputMessage, MessageInfo outputMessage) throws ToolException {
        JavaReturn jreturn;
        List<MessagePartInfo> outputParts = outputMessage.getMessageParts();
        List<MessagePartInfo> inputParts = inputMessage.getMessageParts();
        if (this.messagePartsNotUnique(inputMessage) || this.messagePartsNotUnique(outputMessage)) {
            this.processOutput(method, inputMessage, outputMessage);
            return;
        }
        if (outputParts.size() == 0) {
            this.addVoidReturn(method);
            return;
        }
        MessagePartInfo inputPart = inputParts.size() > 0 ? inputParts.iterator().next() : null;
        MessagePartInfo outputPart = outputParts.size() > 0 ? outputParts.iterator().next() : null;
        List<QName> inputWrapElement = null;
        List<QName> outputWrapElement = null;
        if (inputPart != null) {
            inputWrapElement = ProcessorUtil.getWrappedElementQNames(this.context, inputPart.getElementQName());
        }
        if (outputPart != null) {
            outputWrapElement = ProcessorUtil.getWrappedElementQNames(this.context, outputPart.getElementQName());
        }
        if (inputWrapElement == null || outputWrapElement.size() == 0) {
            this.addVoidReturn(method);
            return;
        }
        method.setReturn(null);
        boolean qualified = ProcessorUtil.isSchemaFormQualified(this.context, outputPart.getElementQName());
        if (outputWrapElement.size() == 1 && inputWrapElement != null) {
            QName outElement = outputWrapElement.iterator().next();
            boolean sameWrapperChild = false;
            for (QName inElement : inputWrapElement) {
                if (!this.isSameWrapperChild(inElement, outElement)) continue;
                JavaParameter jpIn = null;
                for (JavaParameter j : method.getParameters()) {
                    if (!inElement.equals(j.getQName())) continue;
                    jpIn = j;
                }
                JavaParameter jp = this.getParameterFromQName(outputPart.getElementQName(), outElement, JavaType.Style.INOUT, outputPart);
                if (!qualified) {
                    jp.setTargetNamespace("");
                }
                if (!jpIn.getClassName().equals(jp.getClassName())) {
                    jp.setStyle(JavaType.Style.OUT);
                }
                this.addParameter(method, jp);
                sameWrapperChild = true;
                if (method.getReturn() != null) break;
                this.addVoidReturn(method);
                break;
            }
            if (!sameWrapperChild) {
                jreturn = this.getReturnFromQName(outElement, outputPart);
                if (!qualified) {
                    jreturn.setTargetNamespace("");
                }
                method.setReturn(jreturn);
                return;
            }
        }
        for (QName outElement : outputWrapElement) {
            JAXWSBinding mBinding;
            if ("return".equals(outElement.getLocalPart())) {
                if (method.getReturn() != null) {
                    Message msg = new Message("WRAPPER_STYLE_TWO_RETURN_TYPES", LOG, new Object[0]);
                    throw new ToolException(msg);
                }
                jreturn = this.getReturnFromQName(outElement, outputPart);
                if (!qualified) {
                    jreturn.setTargetNamespace("");
                }
                method.setReturn(jreturn);
                continue;
            }
            boolean sameWrapperChild = false;
            if (inputWrapElement != null) {
                for (QName inElement : inputWrapElement) {
                    if (!this.isSameWrapperChild(inElement, outElement)) continue;
                    JavaParameter jpIn = null;
                    for (JavaParameter j : method.getParameters()) {
                        if (!inElement.equals(j.getQName())) continue;
                        jpIn = j;
                    }
                    JavaParameter jp = this.getParameterFromQName(outputPart.getElementQName(), outElement, JavaType.Style.INOUT, outputPart);
                    if (!qualified) {
                        jp.setTargetNamespace("");
                    }
                    if (!jpIn.getClassName().equals(jp.getClassName())) {
                        jp.setStyle(JavaType.Style.OUT);
                    }
                    this.addParameter(method, jp);
                    sameWrapperChild = true;
                    break;
                }
            }
            if (sameWrapperChild) continue;
            JavaParameter jp = this.getParameterFromQName(outputPart.getElementQName(), outElement, JavaType.Style.OUT, outputPart);
            if (!qualified) {
                jp.setTargetNamespace("");
            }
            if ((mBinding = outputMessage.getOperation().getExtensor(JAXWSBinding.class)) != null && mBinding.getJaxwsParas() != null) {
                for (JAXWSParameter jwsp : mBinding.getJaxwsParas()) {
                    if (!outElement.equals(jwsp.getElementName())) continue;
                    jp.setName(jwsp.getName());
                }
            }
            this.addParameter(method, jp);
        }
        if (method.getReturn() == null) {
            this.addVoidReturn(method);
        }
    }

    private void addVoidReturn(JavaMethod method) {
        JavaReturn returnType = new JavaReturn("return", "void", null);
        method.setReturn(returnType);
    }

    private boolean isSameWrapperChild(QName in, QName out) {
        if (!in.getLocalPart().equals(out.getLocalPart())) {
            return false;
        }
        return in.getNamespaceURI().equals(out.getNamespaceURI());
    }

    private JavaParameter getParameterFromQName(QName wrapperElement, QName item, JavaType.Style style, MessagePartInfo part) {
        String fullJavaName = "";
        fullJavaName = this.dataBinding.getWrappedElementType(wrapperElement, item);
        String targetNamespace = item.getNamespaceURI();
        String jpname = ProcessorUtil.mangleNameToVariableName(item.getLocalPart());
        JavaParameter parameter = new JavaParameter(jpname, fullJavaName, targetNamespace);
        parameter.setStyle(style);
        parameter.setQName(item);
        parameter.setDefaultValueWriter(ProcessorUtil.getDefaultValueWriterForWrappedElement(part, this.context, item));
        if (style == JavaType.Style.OUT || style == JavaType.Style.INOUT) {
            parameter.setHolder(true);
            parameter.setHolderName(Holder.class.getName());
            String holderClass = fullJavaName;
            if (JAXBUtils.holderClass(fullJavaName) != null) {
                holderClass = JAXBUtils.holderClass(fullJavaName).getName();
            }
            parameter.setClassName(holderClass);
        }
        return parameter;
    }

    private JavaReturn getReturnFromQName(QName element, MessagePartInfo part) {
        String fullJavaName = "";
        String simpleJavaName = "";
        simpleJavaName = fullJavaName = this.dataBinding.getWrappedElementType(part.getElementQName(), element);
        int index = fullJavaName.lastIndexOf(".");
        if (index > -1) {
            simpleJavaName = fullJavaName.substring(index);
        }
        String targetNamespace = "";
        targetNamespace = this.isHeader(part) ? part.getMessageInfo().getOperation().getInterface().getService().getTargetNamespace() : element.getNamespaceURI();
        String jpname = ProcessorUtil.mangleNameToVariableName(simpleJavaName);
        JavaReturn returnType = new JavaReturn(jpname, fullJavaName, targetNamespace);
        returnType.setDefaultValueWriter(ProcessorUtil.getDefaultValueWriterForWrappedElement(part, this.context, element));
        returnType.setQName(element);
        returnType.setStyle(JavaType.Style.OUT);
        return returnType;
    }

    private boolean isHeader(MessagePartInfo part) {
        return Boolean.TRUE.equals(part.getProperty(HEADER));
    }

    private void buildParamModelsWithoutOrdering(JavaMethod method, MessageInfo inputMessage, MessageInfo outputMessage) throws ToolException {
        boolean wrapped = method.isWrapperStyle();
        if (wrapped) {
            String fullJavaName;
            if (inputMessage != null) {
                List<MessagePartInfo> inputParts = inputMessage.getMessageParts();
                MessagePartInfo inputPart = inputParts.size() > 0 ? inputParts.iterator().next() : null;
                List<QName> inputWrapElement = null;
                if (inputPart != null) {
                    inputWrapElement = ProcessorUtil.getWrappedElementQNames(this.context, inputPart.getElementQName());
                }
                if (inputWrapElement != null) {
                    for (QName item : inputWrapElement) {
                        fullJavaName = this.dataBinding.getWrappedElementType(inputPart.getElementQName(), item);
                        if (!StringUtils.isEmpty(fullJavaName)) continue;
                        wrapped = false;
                        break;
                    }
                }
            }
            if (outputMessage != null) {
                List<MessagePartInfo> outputParts = outputMessage.getMessageParts();
                MessagePartInfo outputPart = outputParts.size() > 0 ? outputParts.iterator().next() : null;
                List<QName> outputWrapElement = null;
                if (outputPart != null) {
                    outputWrapElement = ProcessorUtil.getWrappedElementQNames(this.context, outputPart.getElementQName());
                }
                if (outputWrapElement != null) {
                    for (QName item : outputWrapElement) {
                        fullJavaName = this.dataBinding.getWrappedElementType(outputPart.getElementQName(), item);
                        if (!StringUtils.isEmpty(fullJavaName)) continue;
                        wrapped = false;
                        break;
                    }
                }
            }
            if (!wrapped) {
                method.setWrapperStyle(false);
            }
        }
        if (inputMessage != null) {
            if (method.isWrapperStyle()) {
                this.processWrappedInput(method, inputMessage);
            } else {
                this.processInput(method, inputMessage);
            }
        }
        if (outputMessage == null) {
            this.processReturn(method, null);
        } else if (method.isWrapperStyle()) {
            this.processWrappedOutput(method, inputMessage, outputMessage);
        } else {
            this.processOutput(method, inputMessage, outputMessage);
        }
    }

    private void buildParamModelsWithOrdering(JavaMethod method, MessageInfo inputMessage, MessageInfo outputMessage, List<String> parameterList) throws ToolException {
        Map<QName, MessagePartInfo> inputPartsMap = inputMessage.getMessagePartsMap();
        Map<Object, Object> outputPartsMap = new LinkedHashMap();
        if (outputMessage != null) {
            outputPartsMap = outputMessage.getMessagePartsMap();
        }
        List<MessagePartInfo> inputParts = inputMessage.getMessageParts();
        List<Object> outputParts = new ArrayList();
        if (outputMessage != null) {
            outputParts = outputMessage.getMessageParts();
        }
        ArrayList<MessagePartInfo> inputUnlistedParts = new ArrayList<MessagePartInfo>();
        ArrayList<MessagePartInfo> outputUnlistedParts = new ArrayList<MessagePartInfo>();
        for (MessagePartInfo messagePartInfo : inputParts) {
            if (parameterList.contains(messagePartInfo.getName().getLocalPart())) continue;
            inputUnlistedParts.add(messagePartInfo);
        }
        if (this.isRequestResponse(method)) {
            for (MessagePartInfo messagePartInfo : outputParts) {
                MessagePartInfo inpart;
                if (parameterList.contains(messagePartInfo.getName().getLocalPart()) || (inpart = inputMessage.getMessagePart(messagePartInfo.getName())) != null && (inpart == null || this.isSamePart(inpart, messagePartInfo))) continue;
                outputUnlistedParts.add(messagePartInfo);
            }
            if (outputUnlistedParts.size() == 1) {
                this.processReturn(method, (MessagePartInfo)outputUnlistedParts.get(0));
                outputPartsMap.remove(outputUnlistedParts.get(0));
                outputUnlistedParts.clear();
            } else {
                this.processReturn(method, null);
            }
        } else {
            this.processReturn(method, null);
        }
        int n = parameterList.size();
        for (int index = 0; index < n; ++index) {
            String partName = parameterList.get(index);
            MessagePartInfo part = inputPartsMap.get(inputMessage.getMessagePartQName(partName));
            JavaType.Style style = JavaType.Style.IN;
            if (part == null) {
                part = (MessagePartInfo)outputPartsMap.get(inputMessage.getMessagePartQName(partName));
                style = JavaType.Style.OUT;
            } else if (outputPartsMap.get(inputMessage.getMessagePartQName(partName)) != null && this.isSamePart(part, (MessagePartInfo)outputPartsMap.get(inputMessage.getMessagePartQName(partName)))) {
                style = JavaType.Style.INOUT;
            }
            if (part == null) continue;
            this.addParameter(method, this.getParameterFromPart(method, part, style));
        }
        for (MessagePartInfo part : inputUnlistedParts) {
            this.addParameter(method, this.getParameterFromPart(method, part, JavaType.Style.IN));
        }
        for (MessagePartInfo part : outputUnlistedParts) {
            this.addParameter(method, this.getParameterFromPart(method, part, JavaType.Style.INOUT));
        }
    }

    private boolean isSamePart(MessagePartInfo part1, MessagePartInfo part2) {
        QName qname1 = part1.getElementQName();
        QName qname2 = part2.getElementQName();
        QName tname1 = part1.getTypeQName();
        QName tname2 = part2.getTypeQName();
        if (qname1 != null && qname2 != null) {
            return qname1.equals(qname2) && (tname1 == null || tname1.equals(tname2));
        }
        if (tname1 != null && tname2 != null) {
            return tname1.equals(tname2);
        }
        return false;
    }

    private boolean isValidOrdering(List<String> parameterOrder, MessageInfo inputMessage, MessageInfo outputMessage) {
        Iterator<String> params = parameterOrder.iterator();
        List<MessagePartInfo> inputParts = inputMessage.getMessageParts();
        List<Object> outputParts = new ArrayList();
        if (outputMessage != null) {
            outputParts = outputMessage.getMessageParts();
        }
        while (params.hasNext()) {
            String param = params.next();
            MessagePartInfo inPart = null;
            MessagePartInfo outPart = null;
            for (MessagePartInfo messagePartInfo : inputParts) {
                if (!param.equals(messagePartInfo.getName().getLocalPart())) continue;
                inPart = messagePartInfo;
                break;
            }
            for (MessagePartInfo messagePartInfo : outputParts) {
                if (!param.equals(messagePartInfo.getName().getLocalPart())) continue;
                outPart = messagePartInfo;
                break;
            }
            if (inPart == null && outPart == null) {
                return false;
            }
            if (inPart == null || outPart == null) continue;
            if (inPart.isElement() != outPart.isElement()) {
                return false;
            }
            if (inPart.isElement() && !inPart.getElementQName().equals(outPart.getElementQName())) {
                return false;
            }
            if (inPart.isElement() || inPart.getTypeQName().equals(outPart.getTypeQName())) continue;
            return false;
        }
        return true;
    }
}

