/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se.state;

import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.se.state.AbstractServiceEngineStateMachine;
import org.apache.cxf.jbi.se.state.ServiceEngineStateFactory;
import org.apache.cxf.jbi.se.state.ServiceEngineStateMachine;

public class ServiceEngineStop
extends AbstractServiceEngineStateMachine {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceEngineStop.class);

    public void changeState(ServiceEngineStateMachine.SEOperation operation, ComponentContext context) throws JBIException {
        LOG.info("in stop state");
        if (operation == ServiceEngineStateMachine.SEOperation.start) {
            this.startSE();
            ServiceEngineStateFactory.getInstance().setCurrentState(ServiceEngineStateFactory.getInstance().getStartState());
        } else if (operation == ServiceEngineStateMachine.SEOperation.shutdown) {
            ServiceEngineStateFactory.getInstance().setCurrentState(ServiceEngineStateFactory.getInstance().getShutdownState());
        } else {
            if (operation == ServiceEngineStateMachine.SEOperation.init) {
                throw new JBIException("This operation is unsupported, cannot init a stopped JBI component");
            }
            if (operation == ServiceEngineStateMachine.SEOperation.stop) {
                throw new JBIException("Cannot stop a JBI component which is already stopped");
            }
        }
    }

    private void startSE() throws JBIException {
        try {
            if (ctx == null) {
                return;
            }
            DeliveryChannel chnl = ctx.getDeliveryChannel();
            this.configureJBITransportFactory(chnl, suManager);
            LOG.info(new Message("SE.STARTUP.COMPLETE", LOG, new Object[0]).toString());
        }
        catch (Throwable e) {
            throw new JBIException(e);
        }
    }
}

