/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.security.wss4j.CryptoCoverageUtil;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.util.WSSecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CryptoCoverageChecker
extends AbstractSoapInterceptor {
    protected List<XPathExpression> xPaths = new ArrayList<XPathExpression>();
    protected Map<String, String> prefixMap = new HashMap<String, String>();

    public CryptoCoverageChecker() {
        this(null, null);
    }

    public CryptoCoverageChecker(Map<String, String> prefixes, List<XPathExpression> xPaths) {
        super("pre-protocol");
        this.addAfter(WSS4JInInterceptor.class.getName());
        this.setPrefixes(prefixes);
        this.setXPaths(xPaths);
    }

    public void handleMessage(SoapMessage message) throws Fault {
        HashSet<WSDataRef> signed = new HashSet<WSDataRef>();
        HashSet<WSDataRef> encrypted = new HashSet<WSDataRef>();
        List results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
        for (Object result : results) {
            WSSecurityEngineResult wser;
            WSHandlerResult wshr = (WSHandlerResult)result;
            Vector wsSecurityEngineSignResults = new Vector();
            Vector wsSecurityEngineEncResults = new Vector();
            WSSecurityUtil.fetchAllActionResults((Vector)wshr.getResults(), (int)2, wsSecurityEngineSignResults);
            WSSecurityUtil.fetchAllActionResults((Vector)wshr.getResults(), (int)4, wsSecurityEngineEncResults);
            for (Object o : wsSecurityEngineSignResults) {
                wser = (WSSecurityEngineResult)o;
                List sl = CastUtils.cast((List)((List)wser.get((Object)"data-ref-uris")));
                if (sl == null) continue;
                if (sl.size() == 1 && ((WSDataRef)sl.get(0)).getName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"))) break;
                for (WSDataRef r : sl) {
                    signed.add(r);
                }
            }
            for (Object o : wsSecurityEngineEncResults) {
                wser = (WSSecurityEngineResult)o;
                List el = CastUtils.cast((List)((List)wser.get((Object)"data-ref-uris")));
                if (el == null) continue;
                for (WSDataRef r : el) {
                    encrypted.add(r);
                }
            }
        }
        for (XPathExpression xPathExpression : this.xPaths) {
            HashSet<WSDataRef> refsToCheck = null;
            switch (xPathExpression.getType()) {
                case SIGNED: {
                    refsToCheck = signed;
                    break;
                }
                case ENCRYPTED: {
                    refsToCheck = encrypted;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected crypto type: " + (Object)((Object)xPathExpression.getType()));
                }
            }
            try {
                CryptoCoverageUtil.checkCoverage((SOAPMessage)message.getContent(SOAPMessage.class), refsToCheck, this.prefixMap, xPathExpression.getXPath(), xPathExpression.getType(), xPathExpression.getScope());
            }
            catch (WSSecurityException e) {
                throw new SoapFault("No " + (Object)((Object)xPathExpression.getType()) + " element found matching XPath " + xPathExpression.getXPath(), Fault.FAULT_CODE_CLIENT);
            }
        }
    }

    public final void setXPaths(List<XPathExpression> xPaths) {
        this.xPaths.clear();
        if (xPaths != null) {
            this.xPaths.addAll(xPaths);
        }
    }

    public final void setPrefixes(Map<String, String> prefixes) {
        this.prefixMap.clear();
        if (prefixes != null) {
            this.prefixMap.putAll(prefixes);
        }
    }

    public static class XPathExpression {
        private final String xPath;
        private final CryptoCoverageUtil.CoverageType type;
        private final CryptoCoverageUtil.CoverageScope scope;

        public XPathExpression(String xPath, CryptoCoverageUtil.CoverageType type, CryptoCoverageUtil.CoverageScope scope) {
            if (xPath == null) {
                throw new NullPointerException("xPath cannot be null.");
            }
            if (type == null) {
                throw new NullPointerException("type cannot be null.");
            }
            this.xPath = xPath;
            this.type = type;
            this.scope = scope;
        }

        public String getXPath() {
            return this.xPath;
        }

        public CryptoCoverageUtil.CoverageType getType() {
            return this.type;
        }

        public CryptoCoverageUtil.CoverageScope getScope() {
            return this.scope;
        }
    }
}

