/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.inbound;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.EndpointUtils;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jca.inbound.DispatchMDBActivationSpec;
import org.apache.cxf.jca.inbound.DispatchMDBInvoker;
import org.apache.cxf.jca.inbound.DispatchMDBMessageListener;
import org.apache.cxf.jca.inbound.InboundEndpoint;
import org.apache.cxf.jca.inbound.MDBActivationSpec;
import org.apache.cxf.jca.inbound.MDBInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.EndpointInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDBActivationWork
implements Work {
    private static final Logger LOG = LogUtils.getL7dLogger(MDBActivationWork.class);
    private static final String MESSAGE_LISTENER_METHOD = "lookupTargetObject";
    private static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpointFactory";
    private static final String MDB_TRANSACTED_METHOD = "MDBTransactedMethod";
    private MDBActivationSpec spec;
    private MessageEndpointFactory endpointFactory;
    private Map<String, InboundEndpoint> endpoints;

    public MDBActivationWork(MDBActivationSpec spec, MessageEndpointFactory endpointFactory, Map<String, InboundEndpoint> endpoints) {
        this.spec = spec;
        this.endpointFactory = endpointFactory;
        this.endpoints = endpoints;
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MDBInvoker invoker = this.createInvoker();
        MessageEndpoint mep = invoker.getMessageEndpoint();
        if (mep == null) {
            return;
        }
        ClassLoader savedClassLoader = null;
        try {
            savedClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = mep.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            this.activate(invoker, classLoader);
        }
        finally {
            invoker.releaseEndpoint(mep);
            if (savedClassLoader != null) {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }

    private void activate(MDBInvoker invoker, ClassLoader classLoader) {
        Class<?> serviceClass = null;
        if (this.spec.getServiceInterfaceClass() != null) {
            try {
                serviceClass = Class.forName(this.spec.getServiceInterfaceClass(), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.severe("Failed to activate service endpoint " + this.spec.getDisplayName() + " due to unable to endpoint listener.");
                return;
            }
        }
        Bus bus = null;
        if (this.spec.getBusConfigLocation() != null) {
            URL url = classLoader.getResource(this.spec.getBusConfigLocation());
            if (url == null) {
                LOG.warning("Unable to get bus configuration from " + this.spec.getBusConfigLocation());
            } else {
                bus = new SpringBusFactory().createBus(url);
            }
        }
        if (bus == null) {
            bus = BusFactory.getDefaultBus();
        }
        Method method = null;
        try {
            Class<DispatchMDBMessageListener> clazz = DispatchMDBMessageListener.class;
            method = clazz.getMethod(MESSAGE_LISTENER_METHOD, String.class);
        }
        catch (Exception ex) {
            LOG.severe("Failed to get method lookupTargetObject from class DispatchMDBMessageListener.");
        }
        Server server = this.createServer(bus, serviceClass, invoker);
        if (server == null) {
            LOG.severe("Failed to create CXF facade service endpoint.");
            return;
        }
        EndpointInfo ei = server.getEndpoint().getEndpointInfo();
        ei.setProperty(MESSAGE_ENDPOINT_FACTORY, (Object)this.endpointFactory);
        ei.setProperty(MDB_TRANSACTED_METHOD, (Object)method);
        server.start();
        this.endpoints.put(this.spec.getDisplayName(), new InboundEndpoint(server, invoker));
    }

    private Server createServer(Bus bus, Class<?> serviceClass, MDBInvoker invoker) {
        Object factory = null;
        factory = serviceClass != null && EndpointUtils.hasWebServiceAnnotation(serviceClass) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating a server using " + factory.getClass().getName());
        }
        if (serviceClass != null) {
            factory.setServiceClass(serviceClass);
        }
        if (this.spec.getWsdlLocation() != null) {
            factory.setWsdlLocation(this.spec.getWsdlLocation());
        }
        if (this.spec.getAddress() != null) {
            factory.setAddress(this.spec.getAddress());
        }
        factory.setBus(bus);
        if (this.spec.getEndpointName() != null) {
            factory.setEndpointName(QName.valueOf(this.spec.getEndpointName()));
        }
        if (this.spec.getSchemaLocations() != null) {
            factory.setSchemaLocations(this.getListOfString(this.spec.getSchemaLocations()));
        }
        if (this.spec.getServiceName() != null) {
            factory.setServiceName(QName.valueOf(this.spec.getServiceName()));
        }
        factory.setInvoker((Invoker)invoker);
        factory.setStart(false);
        Server retval = null;
        retval = factory instanceof JaxWsServerFactoryBean ? this.createServerFromJaxwsEndpoint((JaxWsServerFactoryBean)factory) : factory.create();
        return retval;
    }

    private Server createServerFromJaxwsEndpoint(JaxWsServerFactoryBean factory) {
        EndpointImpl endpoint = new EndpointImpl(factory.getBus(), null, factory);
        endpoint.setWsdlLocation(factory.getWsdlURL());
        endpoint.setImplementorClass(factory.getServiceClass());
        endpoint.setEndpointName(factory.getEndpointName());
        endpoint.setServiceName(factory.getServiceName());
        endpoint.setInvoker(factory.getInvoker());
        endpoint.setSchemaLocations(factory.getSchemaLocations());
        return endpoint.getServer(factory.getAddress());
    }

    private List<String> getListOfString(String str) {
        if (str == null) {
            return null;
        }
        return Arrays.asList(str.split(","));
    }

    private MDBInvoker createInvoker() {
        MDBInvoker answer = null;
        answer = this.spec instanceof DispatchMDBActivationSpec ? new DispatchMDBInvoker(this.endpointFactory, ((DispatchMDBActivationSpec)this.spec).getTargetBeanJndiName()) : new MDBInvoker(this.endpointFactory);
        return answer;
    }
}

