/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.ParameterHandler;
import org.apache.cxf.jaxrs.ext.ProtocolHeaders;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalContextResolver;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpHeaders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalMessageContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProtocolHeaders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProviders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalRequest;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalSearchContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalSecurityContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalUriInfo;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(InjectionUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(InjectionUtils.class);
    private static final String SERVLET_CONFIG_CLASS_NAME = "javax.servlet.ServletConfig";
    private static final String SERVLET_CONTEXT_CLASS_NAME = "javax.servlet.ServletContext";
    private static final String HTTP_SERVLET_REQUEST_CLASS_NAME = "javax.servlet.http.HttpServletRequest";
    private static final String HTTP_SERVLET_RESPONSE_CLASS_NAME = "javax.servlet.http.HttpServletResponse";

    private InjectionUtils() {
    }

    public static boolean isConcreteClass(Class<?> cls) {
        return !cls.isInterface() && !Modifier.isAbstract(cls.getModifiers());
    }

    public static Type getSuperType(Class<?> serviceClass, TypeVariable var) {
        Type[] genInterfaces;
        Type[] arr$;
        int len$;
        int i$;
        int pos;
        TypeVariable<?>[] vars = var.getGenericDeclaration().getTypeParameters();
        for (pos = 0; pos < vars.length && !vars[pos].getName().equals(var.getName()); ++pos) {
        }
        Type[] bounds = var.getBounds();
        if (bounds.length > pos && bounds[pos] != Object.class) {
            return bounds[pos];
        }
        Type genericSubtype = serviceClass.getGenericSuperclass();
        if (genericSubtype == Object.class && (i$ = 0) < (len$ = (arr$ = (genInterfaces = serviceClass.getGenericInterfaces())).length)) {
            Type t = arr$[i$];
            genericSubtype = t;
        }
        Class<?> result = genericSubtype != Object.class ? InjectionUtils.getActualType(genericSubtype, pos) : genericSubtype;
        return result == null ? Object.class : result;
    }

    public static boolean invokeBooleanGetter(Object o, String name) {
        try {
            Method method = o.getClass().getMethod(name, new Class[0]);
            return (Boolean)method.invoke(o, new Object[0]);
        }
        catch (Exception ex) {
            LOG.finest("Can not invoke method " + name + " on object of class " + o.getClass().getName());
            return false;
        }
    }

    public static Method checkProxy(Method methodToInvoke, Object resourceObject) {
        if (Proxy.class.isInstance(resourceObject)) {
            for (Class<?> c : resourceObject.getClass().getInterfaces()) {
                try {
                    Method m = c.getMethod(methodToInvoke.getName(), methodToInvoke.getParameterTypes());
                    if (m != null) {
                        return m;
                    }
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
        }
        return methodToInvoke;
    }

    public static void injectFieldValue(final Field f, final Object o, final Object v) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                f.setAccessible(true);
                try {
                    f.set(o, v);
                }
                catch (IllegalAccessException ex) {
                    InjectionUtils.reportServerError("FIELD_ACCESS_FAILURE", f.getType().getName());
                }
                return null;
            }
        });
    }

    public static Object extractFieldValue(final Field f, final Object o) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                f.setAccessible(true);
                try {
                    return f.get(o);
                }
                catch (IllegalAccessException ex) {
                    InjectionUtils.reportServerError("FIELD_ACCESS_FAILURE", f.getType().getName());
                    return null;
                }
            }
        });
    }

    public static Class<?> getActualType(Type genericType) {
        return InjectionUtils.getActualType(genericType, 0);
    }

    public static Class<?> getActualType(Type genericType, int pos) {
        if (genericType == null) {
            return null;
        }
        if (!ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            Class<?> cls;
            if (genericType instanceof TypeVariable) {
                genericType = InjectionUtils.getType(((TypeVariable)genericType).getBounds(), pos);
            }
            return (cls = (Class<?>)genericType).isArray() ? cls.getComponentType() : cls;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        Type t = InjectionUtils.getType(paramType.getActualTypeArguments(), pos);
        return t instanceof Class ? (Class<?>)t : InjectionUtils.getActualType(t, pos);
    }

    public static Type getType(Type[] types, int pos) {
        if (pos >= types.length) {
            throw new RuntimeException("No type can be found at position " + pos);
        }
        return types[pos];
    }

    public static Class<?> getRawType(Type genericType) {
        ParameterizedType paramType;
        Type t;
        if (genericType == null) {
            return null;
        }
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType && (t = (paramType = (ParameterizedType)genericType).getRawType()) instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    public static Type[] getActualTypes(Type genericType) {
        if (genericType == null || !ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            return null;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        return paramType.getActualTypeArguments();
    }

    public static void injectThroughMethod(Object requestObject, Method method, Object parameterValue) {
        try {
            Method methodToInvoke = InjectionUtils.checkProxy(method, requestObject);
            methodToInvoke.invoke(requestObject, parameterValue);
        }
        catch (IllegalAccessException ex) {
            InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName());
        }
        catch (Exception ex) {
            InjectionUtils.reportServerError("METHOD_INJECTION_FAILURE", method.getName());
        }
    }

    public static Object extractFromMethod(Object requestObject, Method method) {
        try {
            Method methodToInvoke = InjectionUtils.checkProxy(method, requestObject);
            return methodToInvoke.invoke(requestObject, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName());
        }
        catch (Exception ex) {
            InjectionUtils.reportServerError("METHOD_INJECTION_FAILURE", method.getName());
        }
        return null;
    }

    public static Object handleParameter(String value, Class<?> pClass, ParameterType pType, Message message) {
        ParameterHandler pm;
        String mName;
        String[] methodNames;
        String[] stringArray;
        if (value == null) {
            return null;
        }
        if (pType == ParameterType.PATH) {
            PathSegmentImpl ps = new PathSegmentImpl(value, false);
            if (PathSegment.class.isAssignableFrom(pClass)) {
                return ps;
            }
            value = ps.getPath();
        }
        if (pClass.isPrimitive()) {
            try {
                return PrimitiveUtils.read((String)value, pClass);
            }
            catch (NumberFormatException nfe) {
                if (pType == ParameterType.PATH) {
                    throw new WebApplicationException((Throwable)nfe, Response.Status.NOT_FOUND);
                }
                throw new WebApplicationException((Throwable)nfe, Response.Status.BAD_REQUEST);
            }
        }
        try {
            Constructor<?> c = pClass.getConstructor(String.class);
            return c.newInstance(value);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.severe(new org.apache.cxf.common.i18n.Message("CLASS_CONSTRUCTOR_FAILURE", BUNDLE, new Object[]{pClass.getName()}).toString());
            throw new WebApplicationException((Throwable)ex, HttpUtils.getParameterFailureStatus(pType));
        }
        Object result = null;
        if (pClass.isEnum()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "fromString";
            stringArray2[1] = "fromValue";
            stringArray = stringArray2;
            stringArray2[2] = "valueOf";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "valueOf";
            stringArray = stringArray3;
            stringArray3[1] = "fromString";
        }
        String[] arr$ = methodNames = stringArray;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (result = InjectionUtils.evaluateFactoryMethod(value, pClass, pType, mName = arr$[i$])) == null; ++i$) {
        }
        if (result == null && message != null && (pm = ProviderFactory.getInstance(message).createParameterHandler(pClass)) != null) {
            result = pm.fromString(value);
        }
        if (result != null) {
            return result;
        }
        InjectionUtils.reportServerError("WRONG_PARAMETER_TYPE", pClass.getName());
        return null;
    }

    public static void reportServerError(String messageName, String parameter) {
        org.apache.cxf.common.i18n.Message errorMessage = new org.apache.cxf.common.i18n.Message(messageName, BUNDLE, new Object[]{parameter});
        LOG.severe(errorMessage.toString());
        Response r = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)errorMessage.toString()).build();
        throw new WebApplicationException(r);
    }

    private static Object evaluateFactoryMethod(String value, Class<?> pClass, ParameterType pType, String methodName) {
        try {
            Method m = pClass.getMethod(methodName, String.class);
            if (Modifier.isStatic(m.getModifiers())) {
                return m.invoke(null, value);
            }
        }
        catch (NoSuchMethodException ex) {
        }
        catch (Exception ex) {
            Exception t = ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getTargetException() : ex;
            LOG.severe(new org.apache.cxf.common.i18n.Message("CLASS_VALUE_OF_FAILURE", BUNDLE, new Object[]{pClass.getName()}).toString());
            throw new WebApplicationException((Throwable)t, HttpUtils.getParameterFailureStatus(pType));
        }
        return null;
    }

    public static Object handleBean(Class<?> paramType, MultivaluedMap<String, String> values, ParameterType pType, Message message, boolean decoded) {
        String memberKey;
        Object bean = null;
        try {
            bean = paramType.newInstance();
        }
        catch (IllegalAccessException ex) {
            InjectionUtils.reportServerError("CLASS_ACCESS_FAILURE", paramType.getName());
        }
        catch (Exception ex) {
            InjectionUtils.reportServerError("CLASS_INSTANTIATION_FAILURE", paramType.getName());
        }
        HashMap parsedValues = new HashMap();
        for (Map.Entry entry : values.entrySet()) {
            memberKey = (String)entry.getKey();
            String beanKey = null;
            int idx = memberKey.indexOf(46);
            if (idx == -1) {
                beanKey = "." + memberKey;
            } else {
                beanKey = memberKey.substring(0, idx);
                memberKey = memberKey.substring(idx + 1);
            }
            MetadataMap value = (MetadataMap)parsedValues.get(beanKey);
            if (value == null) {
                value = new MetadataMap();
                parsedValues.put(beanKey, value);
            }
            value.put(memberKey, entry.getValue());
        }
        if (parsedValues.size() > 0) {
            for (Map.Entry entry : parsedValues.entrySet()) {
                boolean isbean;
                memberKey = (String)entry.getKey();
                boolean bl = isbean = !memberKey.startsWith(".");
                if (!isbean) {
                    memberKey = memberKey.substring(1);
                }
                AccessibleObject setter = null;
                AccessibleObject getter = null;
                for (Method method : paramType.getMethods()) {
                    if (method.getName().equalsIgnoreCase("set" + memberKey) && method.getParameterTypes().length == 1) {
                        setter = method;
                    } else if (method.getName().equalsIgnoreCase("get" + memberKey) && method.getReturnType() != Void.TYPE) {
                        getter = method;
                    }
                    if (setter != null && getter != null) break;
                }
                if (setter == null) {
                    for (AccessibleObject accessibleObject : paramType.getFields()) {
                        if (!((Field)accessibleObject).getName().equalsIgnoreCase(memberKey)) continue;
                        setter = accessibleObject;
                        getter = accessibleObject;
                        break;
                    }
                }
                if (setter == null || getter == null) continue;
                Class<?> type = null;
                Type genericType = null;
                Object paramValue = null;
                if (setter instanceof Method) {
                    type = ((Method)Method.class.cast(setter)).getParameterTypes()[0];
                    genericType = ((Method)Method.class.cast(setter)).getGenericParameterTypes()[0];
                    paramValue = InjectionUtils.extractFromMethod(bean, (Method)getter);
                } else {
                    type = ((Field)Field.class.cast(setter)).getType();
                    genericType = ((Field)Field.class.cast(setter)).getGenericType();
                    paramValue = InjectionUtils.extractFieldValue((Field)getter, bean);
                }
                List<MultivaluedMap<String, String>> list = InjectionUtils.processValues(type, genericType, (MultivaluedMap<String, String>)((MultivaluedMap)entry.getValue()), isbean);
                for (MultivaluedMap<String, String> processedValues : list) {
                    if (InjectionUtils.isSupportedCollectionOrArray(type)) {
                        Object appendValue = InjectionUtils.injectIntoCollectionOrArray(type, genericType, processedValues, isbean, true, pType, message);
                        paramValue = InjectionUtils.mergeCollectionsOrArrays(paramValue, appendValue, genericType);
                    } else if (isbean) {
                        paramValue = InjectionUtils.handleBean(type, processedValues, pType, message, decoded);
                    } else {
                        String value = InjectionUtils.decodeValue((String)((List)processedValues.values().iterator().next()).get(0), decoded, pType);
                        paramValue = InjectionUtils.handleParameter(value, type, pType, message);
                    }
                    if (paramValue == null) continue;
                    if (setter instanceof Method) {
                        InjectionUtils.injectThroughMethod(bean, setter, paramValue);
                        continue;
                    }
                    InjectionUtils.injectFieldValue((Field)setter, bean, paramValue);
                }
            }
        }
        return bean;
    }

    /*
     * WARNING - void declaration
     */
    private static List<MultivaluedMap<String, String>> processValues(Class<?> type, Type genericType, MultivaluedMap<String, String> values, boolean isbean) {
        ArrayList<MultivaluedMap<String, String>> valuesList = new ArrayList<MultivaluedMap<String, String>>();
        if (isbean && InjectionUtils.isSupportedCollectionOrArray(type)) {
            Class<?> realType = InjectionUtils.getActualType(genericType);
            for (Map.Entry entry : values.entrySet()) {
                String memberKey = (String)entry.getKey();
                Class<?> memberType = null;
                for (Method method : realType.getMethods()) {
                    if (!method.getName().equalsIgnoreCase("set" + memberKey) || method.getParameterTypes().length != 1) continue;
                    memberType = method.getParameterTypes()[0];
                    break;
                }
                if (memberType == null) {
                    for (AccessibleObject accessibleObject : realType.getFields()) {
                        if (!((Field)accessibleObject).getName().equalsIgnoreCase(memberKey)) continue;
                        memberType = ((Field)accessibleObject).getType();
                        break;
                    }
                }
                if (memberType != null && InjectionUtils.isSupportedCollectionOrArray(memberType)) continue;
                int idx = 0;
                for (String value : (List)entry.getValue()) {
                    void var13_21;
                    MultivaluedMap multivaluedMap;
                    MultivaluedMap multivaluedMap2 = multivaluedMap = idx < valuesList.size() ? (MultivaluedMap)valuesList.get(idx) : null;
                    if (multivaluedMap == null) {
                        MetadataMap metadataMap = new MetadataMap();
                        valuesList.add(metadataMap);
                    }
                    var13_21.add((Object)memberKey, (Object)value);
                    ++idx;
                }
            }
        } else {
            valuesList.add(values);
        }
        return valuesList;
    }

    public static boolean isSupportedCollectionOrArray(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || type.isArray();
    }

    private static Object mergeCollectionsOrArrays(Object first, Object second, Type genericType) {
        if (first == null) {
            return second;
        }
        if (first instanceof Collection) {
            ((Collection)Collection.class.cast(first)).addAll((Collection)second);
            return first;
        }
        int firstLen = Array.getLength(first);
        int secondLen = Array.getLength(second);
        Object mergedArray = Array.newInstance(InjectionUtils.getActualType(genericType), firstLen + secondLen);
        System.arraycopy(first, 0, mergedArray, 0, firstLen);
        System.arraycopy(second, 0, mergedArray, firstLen, secondLen);
        return mergedArray;
    }

    static Class<?> getCollectionType(Class<?> rawType) {
        Class type = null;
        if (SortedSet.class.isAssignableFrom(rawType)) {
            type = TreeSet.class;
        } else if (Set.class.isAssignableFrom(rawType)) {
            type = HashSet.class;
        } else if (Collection.class.isAssignableFrom(rawType)) {
            type = ArrayList.class;
        }
        return type;
    }

    private static Object injectIntoCollectionOrArray(Class<?> rawType, Type genericType, MultivaluedMap<String, String> values, boolean isbean, boolean decoded, ParameterType pathParam, Message message) {
        Class<?> type = InjectionUtils.getCollectionType(rawType);
        Class<?> realType = InjectionUtils.getActualType(genericType);
        Object theValues = null;
        if (type != null) {
            try {
                theValues = type.newInstance();
            }
            catch (IllegalAccessException ex) {
                InjectionUtils.reportServerError("CLASS_ACCESS_FAILURE", type.getName());
            }
            catch (Exception ex) {
                InjectionUtils.reportServerError("CLASS_INSTANTIATION_FAILURE", type.getName());
            }
        } else {
            theValues = Array.newInstance(realType, isbean ? 1 : ((List)values.values().iterator().next()).size());
        }
        if (isbean) {
            Object o = InjectionUtils.handleBean(realType, values, pathParam, message, decoded);
            InjectionUtils.addToCollectionValues(theValues, o, 0);
        } else {
            List<String> valuesList = (List<String>)values.values().iterator().next();
            valuesList = InjectionUtils.checkPathSegment(valuesList, realType, pathParam);
            for (int ind = 0; ind < valuesList.size(); ++ind) {
                String value = InjectionUtils.decodeValue(valuesList.get(ind), decoded, pathParam);
                Object o = InjectionUtils.handleParameter(value, realType, pathParam, message);
                InjectionUtils.addToCollectionValues(theValues, o, ind);
            }
        }
        return theValues;
    }

    private static void addToCollectionValues(Object theValues, Object o, int index) {
        if (o != null) {
            if (theValues instanceof Collection) {
                ((Collection)Collection.class.cast(theValues)).add(o);
            } else {
                ((Object[])theValues)[index] = o;
            }
        }
    }

    private static List<String> checkPathSegment(List<String> values, Class<?> type, ParameterType pathParam) {
        if (pathParam != ParameterType.PATH || !PathSegment.class.isAssignableFrom(type)) {
            return values;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        for (String v : values) {
            String[] segments;
            for (String s : segments = v.split("/")) {
                if (s.length() == 0) continue;
                newValues.add(s);
            }
            if (!v.endsWith("/")) continue;
            newValues.add("");
        }
        return newValues;
    }

    public static Object createParameterObject(List<String> paramValues, Class<?> paramType, Type genericType, String defaultValue, boolean decoded, ParameterType pathParam, Message message) {
        if (paramValues == null) {
            if (defaultValue != null) {
                paramValues = Collections.singletonList(defaultValue);
            } else if (paramType.isPrimitive()) {
                paramValues = Collections.singletonList(Boolean.TYPE == paramType ? "false" : "0");
            } else if (InjectionUtils.isSupportedCollectionOrArray(paramType)) {
                paramValues = Collections.emptyList();
            } else {
                return null;
            }
        }
        Object value = null;
        if (InjectionUtils.isSupportedCollectionOrArray(paramType)) {
            MetadataMap<String, String> paramValuesMap = new MetadataMap<String, String>();
            paramValuesMap.put("", paramValues);
            value = InjectionUtils.injectIntoCollectionOrArray(paramType, genericType, paramValuesMap, false, decoded, pathParam, message);
        } else {
            String result = null;
            if (paramValues.size() > 0) {
                boolean isLast = pathParam == ParameterType.PATH;
                String string = result = isLast ? paramValues.get(paramValues.size() - 1) : paramValues.get(0);
            }
            if (result != null) {
                result = InjectionUtils.decodeValue(result, decoded, pathParam);
                value = InjectionUtils.handleParameter(result, paramType, pathParam, message);
            }
        }
        return value;
    }

    public static ThreadLocalProxy createThreadLocalProxy(Class<?> type) {
        ThreadLocalProxy<UriInfo> proxy = null;
        if (UriInfo.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalUriInfo();
        } else if (HttpHeaders.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalHttpHeaders();
        } else if (ProtocolHeaders.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalProtocolHeaders();
        } else if (SecurityContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalSecurityContext();
        } else if (ContextResolver.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalContextResolver();
        } else if (Request.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalRequest();
        } else if (Providers.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalProviders();
        } else if (SearchContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalSearchContext();
        } else if (MessageContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalMessageContext();
        }
        if (proxy == null && InjectionUtils.isServletApiContext(type.getName())) {
            proxy = InjectionUtils.createThreadLocalServletApiContext(type.getName());
        }
        return proxy;
    }

    private static boolean isServletApiContext(String name) {
        return name.startsWith("javax.servlet.");
    }

    private static ThreadLocalProxy createThreadLocalServletApiContext(String name) {
        String proxyClassName = null;
        if (HTTP_SERVLET_REQUEST_CLASS_NAME.equals(name)) {
            proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpServletRequest";
        } else if (HTTP_SERVLET_RESPONSE_CLASS_NAME.equals(name)) {
            proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpServletResponse";
        } else if (SERVLET_CONTEXT_CLASS_NAME.equals(name)) {
            proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalServletContext";
        } else if (SERVLET_CONFIG_CLASS_NAME.equals(name)) {
            proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalServletConfig";
        }
        try {
            return (ThreadLocalProxy)ClassLoaderUtils.loadClass((String)proxyClassName, InjectionUtils.class).newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void injectContextProxies(AbstractResourceInfo cri, Object instance) {
        ThreadLocalProxy proxy;
        if (!cri.isSingleton()) {
            return;
        }
        for (Map.Entry<Class<?>, Method> entry : cri.getContextMethods().entrySet()) {
            proxy = cri.getContextSetterProxy(entry.getValue());
            InjectionUtils.injectThroughMethod(instance, entry.getValue(), proxy);
        }
        for (Field f : cri.getContextFields()) {
            proxy = cri.getContextFieldProxy(f);
            InjectionUtils.injectFieldValue(f, instance, proxy);
        }
        for (Field f : cri.getResourceFields()) {
            proxy = cri.getResourceFieldProxy(f);
            InjectionUtils.injectFieldValue(f, instance, proxy);
        }
    }

    public static void injectContextField(AbstractResourceInfo cri, Field f, Object o, Object value, boolean resource) {
        if (!cri.isSingleton()) {
            InjectionUtils.injectFieldValue(f, o, value);
        } else {
            ThreadLocalProxy proxy;
            ThreadLocalProxy threadLocalProxy = proxy = resource ? cri.getResourceFieldProxy(f) : cri.getContextFieldProxy(f);
            if (proxy != null) {
                proxy.set(value);
            }
        }
    }

    public static void injectContextMethods(Object requestObject, AbstractResourceInfo cri, Message message) {
        for (Map.Entry<Class<?>, Method> entry : cri.getContextMethods().entrySet()) {
            Object o = JAXRSUtils.createContextValue(message, entry.getValue().getGenericParameterTypes()[0], entry.getKey());
            if (o == null) continue;
            if (!cri.isSingleton()) {
                InjectionUtils.injectThroughMethod(requestObject, entry.getValue(), o);
                continue;
            }
            ThreadLocalProxy proxy = cri.getContextSetterProxy(entry.getValue());
            if (proxy == null) continue;
            proxy.set(o);
        }
    }

    public static void injectContextFields(Object o, AbstractResourceInfo cri, Message m) {
        for (Field f : cri.getContextFields()) {
            Object value = JAXRSUtils.createContextValue(m, f.getGenericType(), f.getType());
            InjectionUtils.injectContextField(cri, f, o, value, false);
        }
    }

    public static void injectResourceFields(Object o, AbstractResourceInfo cri, Message m) {
        for (Field f : cri.getResourceFields()) {
            Object value = JAXRSUtils.createResourceValue(m, f.getGenericType(), f.getType());
            InjectionUtils.injectContextField(cri, f, o, value, true);
        }
    }

    public static MultivaluedMap<String, Object> extractValuesFromBean(Object bean, String baseName) {
        MetadataMap<String, Object> values = new MetadataMap<String, Object>();
        InjectionUtils.fillInValuesFromBean(bean, baseName, values);
        return values;
    }

    public static void fillInValuesFromBean(Object bean, String baseName, MultivaluedMap<String, Object> values) {
        for (Method m : bean.getClass().getMethods()) {
            Object value;
            String propertyName;
            if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0 || m.getName().length() <= 3 || baseName.contains(propertyName = (propertyName = m.getName().substring(3)).length() == 1 ? propertyName.toLowerCase() : propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1)) || "class".equals(propertyName)) continue;
            if (!"".equals(baseName)) {
                propertyName = baseName + "." + propertyName;
            }
            if ((value = InjectionUtils.extractFromMethod(bean, m)) == null) continue;
            if (InjectionUtils.isPrimitive(value.getClass())) {
                values.putSingle((Object)propertyName, value);
                continue;
            }
            if (InjectionUtils.isSupportedCollectionOrArray(value.getClass())) {
                List<Object> theValues = null;
                theValues = value.getClass().isArray() ? Arrays.asList(value) : CastUtils.cast((List)((List)value));
                values.put((Object)propertyName, theValues);
                continue;
            }
            InjectionUtils.fillInValuesFromBean(value, propertyName, values);
        }
    }

    public static Map<Parameter, Class<?>> getParametersFromBeanClass(Class<?> beanClass, ParameterType type, boolean checkIgnorable) {
        LinkedHashMap params = new LinkedHashMap();
        for (Method m : beanClass.getMethods()) {
            if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0 || m.getName().length() <= 3) continue;
            String propertyName = m.getName().substring(3).toLowerCase();
            if (m.getReturnType() == Class.class || checkIgnorable && InjectionUtils.canPropertyBeIgnored(m, propertyName)) continue;
            params.put(new Parameter(type, propertyName), m.getReturnType());
        }
        return params;
    }

    private static boolean canPropertyBeIgnored(Method m, String propertyName) {
        for (Annotation ann : m.getAnnotations()) {
            String annType = ann.annotationType().getName();
            if (!"org.apache.cxf.aegis.type.java5.IgnoreProperty".equals(annType) && !"javax.xml.bind.annotation.XmlTransient".equals(annType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || String.class == type;
    }

    public static String decodeValue(String value, boolean decode, ParameterType param) {
        if (!decode) {
            return value;
        }
        if (param == ParameterType.PATH || param == ParameterType.MATRIX) {
            return HttpUtils.pathDecode(value);
        }
        return HttpUtils.urlDecode(value);
    }

    public static void invokeLifeCycleMethod(Object instance, Method method) {
        if (method != null) {
            method = InjectionUtils.checkProxy(method, instance);
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                String msg = "Method " + method.getName() + " can not be invoked" + " due to InvocationTargetException";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            catch (IllegalAccessException ex) {
                String msg = "Method " + method.getName() + " can not be invoked" + " due to IllegalAccessException";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
        }
    }

    public static <T> T convertStringToPrimitive(String value, Class<T> cls) {
        if (String.class == cls) {
            return cls.cast(value);
        }
        if (cls.isPrimitive()) {
            return (T)PrimitiveUtils.read((String)value, cls);
        }
        try {
            Method m = cls.getMethod("valueOf", String.class);
            return cls.cast(m.invoke(null, value));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

