/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.extension.RegistryImpl;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderLoader;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class PolicyInterceptorProviderRegistryImpl
extends RegistryImpl<QName, PolicyInterceptorProvider>
implements PolicyInterceptorProviderRegistry,
BusExtension {
    private Bus bus;
    private boolean dynamicLoaded;

    public PolicyInterceptorProviderRegistryImpl() {
        super(null);
    }

    public PolicyInterceptorProviderRegistryImpl(Bus b) {
        super(null);
        this.setBus(b);
    }

    public PolicyInterceptorProviderRegistryImpl(Map<QName, PolicyInterceptorProvider> interceptors) {
        super(interceptors);
    }

    public PolicyInterceptorProviderRegistryImpl(MapProvider<QName, PolicyInterceptorProvider> interceptors) {
        super(interceptors.createMap());
    }

    public PolicyInterceptorProviderRegistryImpl(Bus b, MapProvider<QName, PolicyInterceptorProvider> interceptors) {
        super(interceptors.createMap());
        this.setBus(b);
    }

    @Resource
    public final void setBus(Bus b) {
        this.bus = b;
        if (b != null) {
            b.setExtension((Object)this, PolicyInterceptorProviderRegistry.class);
        }
    }

    public void register(PolicyInterceptorProvider provider) {
        for (QName qn : provider.getAssertionTypes()) {
            super.register((Object)qn, (Object)provider);
        }
    }

    public Class<?> getRegistrationType() {
        return PolicyInterceptorProviderRegistry.class;
    }

    private synchronized void loadDynamic() {
        if (!this.dynamicLoaded && this.bus != null) {
            this.dynamicLoaded = true;
            ConfiguredBeanLocator c = (ConfiguredBeanLocator)this.bus.getExtension(ConfiguredBeanLocator.class);
            if (c != null) {
                c.getBeansOfType(PolicyInterceptorProviderLoader.class);
            }
        }
    }

    public List<Interceptor<? extends Message>> getInterceptors(Collection<PolicyAssertion> alternative, boolean out, boolean fault) {
        this.loadDynamic();
        ArrayList<Interceptor<? extends Message>> interceptors = new ArrayList<Interceptor<? extends Message>>();
        for (PolicyAssertion a : alternative) {
            QName qn;
            PolicyInterceptorProvider pp;
            if (a.isOptional() || null == (pp = (PolicyInterceptorProvider)this.get(qn = a.getName()))) continue;
            interceptors.addAll(out ? (fault ? pp.getOutFaultInterceptors() : pp.getOutInterceptors()) : (fault ? pp.getInFaultInterceptors() : pp.getInInterceptors()));
        }
        return interceptors;
    }
}

