/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.ws.rs.Path;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSServiceFactoryBean
extends AbstractServiceFactoryBean {
    protected List<ClassResourceInfo> classResourceInfos = new ArrayList<ClassResourceInfo>();
    private Invoker invoker;
    private Executor executor;
    private Map<String, Object> properties;
    private boolean enableStatic;
    private QName serviceName;

    public void setServiceName(QName name) {
        this.serviceName = name;
    }

    public void setEnableStaticResolution(boolean staticResolution) {
        this.enableStatic = staticResolution;
    }

    @Override
    public Service create() {
        this.sendEvent(FactoryBeanListener.Event.START_CREATE, new Object[0]);
        this.initializeServiceModel();
        this.initializeDefaultInterceptors();
        if (this.invoker != null) {
            this.getService().setInvoker(this.getInvoker());
        } else {
            this.getService().setInvoker(this.createInvoker());
        }
        if (this.getExecutor() != null) {
            this.getService().setExecutor(this.getExecutor());
        }
        if (this.getDataBinding() != null) {
            this.getService().setDataBinding(this.getDataBinding());
        }
        Service serv = this.getService();
        this.sendEvent(FactoryBeanListener.Event.END_CREATE, serv);
        return serv;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public List<Class<?>> getResourceClasses() {
        ArrayList resourceClasses = new ArrayList();
        for (ClassResourceInfo cri : this.classResourceInfos) {
            resourceClasses.add(cri.getResourceClass());
        }
        return resourceClasses;
    }

    public List<ClassResourceInfo> getClassResourceInfo() {
        return Collections.unmodifiableList(this.classResourceInfos);
    }

    List<ClassResourceInfo> getRealClassResourceInfo() {
        return this.classResourceInfos;
    }

    public void setResourceClass(Class cls) {
        if (this.getCreatedFromModel(cls) == null) {
            this.classResourceInfos.clear();
            boolean isRoot = AnnotationUtils.getClassAnnotation(cls, Path.class) != null;
            this.createResourceInfo(cls, isRoot);
        }
    }

    public void setResourceClasses(List<Class> classes) {
        for (Class resourceClass : classes) {
            ClassResourceInfo cri = this.getCreatedFromModel(resourceClass);
            if (cri != null) {
                if (InjectionUtils.isConcreteClass(cri.getServiceClass())) continue;
                cri = new ClassResourceInfo(cri);
                cri.setResourceClass(resourceClass);
                this.classResourceInfos.add(cri);
                continue;
            }
            this.createResourceInfo(resourceClass, true);
        }
    }

    public void setUserResources(List<UserResource> resources) {
        Map<String, UserResource> map = this.userResourcesAsMap(resources);
        for (UserResource ur : resources) {
            ClassResourceInfo cri;
            if (ur.getPath() == null || (cri = ResourceUtils.createClassResourceInfo(map, ur, true, this.enableStatic)) == null) continue;
            this.classResourceInfos.add(cri);
        }
    }

    public void setUserResourcesWithServiceClass(List<UserResource> resources, Class<?> ... sClasses) {
        Map<String, UserResource> map = this.userResourcesAsMap(resources);
        for (Class<?> sClass : sClasses) {
            ClassResourceInfo cri = ResourceUtils.createServiceClassResourceInfo(map, map.get(sClass.getName()), sClass, true, this.enableStatic);
            if (cri == null) continue;
            this.classResourceInfos.add(cri);
        }
    }

    private Map<String, UserResource> userResourcesAsMap(List<UserResource> resources) {
        HashMap<String, UserResource> map = new HashMap<String, UserResource>();
        for (UserResource ur : resources) {
            map.put(ur.getName(), ur);
        }
        return map;
    }

    protected ClassResourceInfo createResourceInfo(Class cls, boolean isRoot) {
        ClassResourceInfo classResourceInfo = ResourceUtils.createClassResourceInfo(cls, cls, isRoot, this.enableStatic);
        if (classResourceInfo != null) {
            this.classResourceInfos.add(classResourceInfo);
        }
        return classResourceInfo;
    }

    public void setResourceClasses(Class ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }

    public void setResourceClassesFromBeans(List<Object> beans) {
        for (Object bean : beans) {
            Class realClass = ClassHelper.getRealClass(bean);
            ClassResourceInfo cri = this.getCreatedFromModel(realClass);
            if (cri != null) {
                if (!InjectionUtils.isConcreteClass(cri.getServiceClass())) {
                    cri = new ClassResourceInfo(cri);
                    this.classResourceInfos.add(cri);
                }
                cri.setResourceClass(bean.getClass());
                cri.setResourceProvider(new SingletonResourceProvider(bean));
                continue;
            }
            cri = ResourceUtils.createClassResourceInfo(bean.getClass(), realClass, true, this.enableStatic);
            if (cri == null) continue;
            this.classResourceInfos.add(cri);
            cri.setResourceProvider(new SingletonResourceProvider(bean));
        }
    }

    private ClassResourceInfo getCreatedFromModel(Class<?> realClass) {
        this.sendEvent(FactoryBeanListener.Event.CREATE_FROM_CLASS, realClass);
        for (ClassResourceInfo cri : this.classResourceInfos) {
            if (!cri.isCreatedFromModel() || !cri.isRoot() || !cri.getServiceClass().isAssignableFrom(realClass)) continue;
            return cri;
        }
        return null;
    }

    protected void initializeServiceModel() {
        JAXRSServiceImpl service = new JAXRSServiceImpl(this.classResourceInfos, this.serviceName);
        this.setService(service);
        this.sendEvent(FactoryBeanListener.Event.SERVICE_SET, service);
        if (this.properties != null) {
            service.putAll(this.properties);
        }
    }

    protected Invoker createInvoker() {
        return new JAXRSInvoker();
    }

    @Override
    public void setService(Service service) {
        super.setService(service);
    }
}

