/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringResourceFactory
implements ResourceProvider,
ApplicationContextAware {
    private Constructor<?> c;
    private ApplicationContext ac;
    private String beanId;
    private Method postConstructMethod;
    private Method preDestroyMethod;
    private boolean isSingleton;

    public SpringResourceFactory() {
    }

    public SpringResourceFactory(String name) {
        this.beanId = name;
    }

    private void init() {
        Class type = ClassHelper.getRealClassFromClass(this.ac.getType(this.beanId));
        if (Proxy.isProxyClass(type)) {
            type = ClassHelper.getRealClass(this.ac.getBean(this.beanId));
        }
        this.c = ResourceUtils.findResourceConstructor(type, !this.isSingleton());
        if (this.c == null) {
            throw new RuntimeException("Resource class " + type + " has no valid constructor");
        }
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(type);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(type);
        this.isSingleton = this.ac.isSingleton(this.beanId);
    }

    @Override
    public Object getInstance(Message m) {
        Object instance;
        Object[] values = ResourceUtils.createConstructorArguments(this.c, m);
        Object object = instance = values.length > 0 ? this.ac.getBean(this.beanId, values) : this.ac.getBean(this.beanId);
        if (!this.isSingleton || m == null) {
            InjectionUtils.invokeLifeCycleMethod(instance, this.postConstructMethod);
        }
        return instance;
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public void releaseInstance(Message m, Object o) {
        if (!this.isSingleton) {
            InjectionUtils.invokeLifeCycleMethod(o, this.preDestroyMethod);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ac = applicationContext;
        this.init();
    }

    public void setBeanId(String serviceBeanId) {
        this.beanId = serviceBeanId;
    }

    public ApplicationContext getApplicationContext() {
        return this.ac;
    }

    Constructor getBeanConstructor() {
        return this.c;
    }

    @Override
    public Class<?> getResourceClass() {
        return this.c.getDeclaringClass();
    }
}

