/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedElements;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportingTokens12Builder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP12Constants.SUPPORTING_TOKENS, SP12Constants.SIGNED_SUPPORTING_TOKENS, SP12Constants.ENDORSING_SUPPORTING_TOKENS, SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS, SP12Constants.ENCRYPTED_SUPPORTING_TOKENS, SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS, SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS, SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS);
    PolicyBuilder builder;

    public SupportingTokens12Builder(PolicyBuilder b) {
        this.builder = b;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    public PolicyAssertion build(Element element) {
        QName name = DOMUtils.getElementQName((Element)element);
        SupportingToken supportingToken = null;
        if (SP12Constants.SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_SUPPORTING, SP12Constants.INSTANCE);
        } else if (SP12Constants.SIGNED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED, SP12Constants.INSTANCE);
        } else if (SP12Constants.ENDORSING_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_ENDORSING, SP12Constants.INSTANCE);
        } else if (SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED_ENDORSING, SP12Constants.INSTANCE);
        } else if (SP12Constants.ENCRYPTED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_ENCRYPTED, SP12Constants.INSTANCE);
        } else if (SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED_ENCRYPTED, SP12Constants.INSTANCE);
        } else if (SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_ENDORSING_ENCRYPTED, SP12Constants.INSTANCE);
        } else if (SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED_ENDORSING_ENCRYPTED, SP12Constants.INSTANCE);
        }
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement((Node)element));
        policy = (Policy)policy.normalize(false);
        Iterator iterator = policy.getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), supportingToken);
        }
        return supportingToken;
    }

    private void processAlternative(List assertions, SupportingToken supportingToken) {
        for (Assertion primitive : assertions) {
            QName qname = primitive.getName();
            if (SP12Constants.ALGORITHM_SUITE.equals(qname)) {
                supportingToken.setAlgorithmSuite((AlgorithmSuite)primitive);
                continue;
            }
            if (SP12Constants.SIGNED_PARTS.equals(qname)) {
                supportingToken.setSignedParts((SignedEncryptedParts)primitive);
                continue;
            }
            if (SP12Constants.SIGNED_ELEMENTS.equals(qname)) {
                supportingToken.setSignedElements((SignedEncryptedElements)primitive);
                continue;
            }
            if (SP12Constants.ENCRYPTED_PARTS.equals(qname)) {
                supportingToken.setEncryptedParts((SignedEncryptedParts)primitive);
                continue;
            }
            if (SP12Constants.ENCRYPTED_ELEMENTS.equals(qname)) {
                supportingToken.setEncryptedElements((SignedEncryptedElements)primitive);
                continue;
            }
            if (!(primitive instanceof Token)) continue;
            supportingToken.addToken((Token)primitive);
        }
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

