/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.interceptor.security.SimpleAuthorizingInterceptor;

public class SecureAnnotationsInterceptor
extends SimpleAuthorizingInterceptor {
    private static final String DEFAULT_ANNOTATION_CLASS_NAME = "javax.annotation.security.RolesAllowed";
    private static final Set<String> SKIP_METHODS = new HashSet<String>();
    private String annotationClassName = "javax.annotation.security.RolesAllowed";

    public void setAnnotationClassName(String name) {
        try {
            ClassLoaderUtils.loadClass((String)name, SecureAnnotationsInterceptor.class);
            this.annotationClassName = name;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Annotation class " + name + " is not available");
        }
    }

    public void setSecuredObject(Object object) {
        Class<?> cls = object.getClass();
        String classRolesAllowed = this.getRoles(cls.getAnnotations(), this.annotationClassName);
        HashMap<String, String> rolesMap = new HashMap<String, String>();
        for (Method m : cls.getMethods()) {
            String theRoles;
            if (SKIP_METHODS.contains(m.getName())) continue;
            String methodRolesAllowed = this.getRoles(m.getAnnotations(), this.annotationClassName);
            String string = theRoles = methodRolesAllowed != null ? methodRolesAllowed : classRolesAllowed;
            if (theRoles == null) continue;
            rolesMap.put(m.getName(), theRoles);
        }
        super.setMethodRolesMap(rolesMap);
    }

    private String getRoles(Annotation[] anns, String annName) {
        for (Annotation ann : anns) {
            if (!ann.annotationType().getName().equals(annName)) continue;
            try {
                Method valueMethod = ann.annotationType().getMethod("value", new Class[0]);
                String[] roles = (String[])valueMethod.invoke((Object)ann, new Object[0]);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < roles.length; ++i) {
                    sb.append(roles[i]);
                    if (i + 1 >= roles.length) continue;
                    sb.append(" ");
                }
                return sb.toString();
            }
            catch (Exception ex) {
                break;
            }
        }
        return null;
    }

    static {
        SKIP_METHODS.addAll(Arrays.asList("wait", "notify", "notifyAll", "equals", "toString", "hashCode"));
    }
}

