/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.security.SecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolePrefixSecurityContextImpl
implements SecurityContext {
    private Principal p;
    private Set<String> roles;

    public RolePrefixSecurityContextImpl(Subject subject, String rolePrefix) {
        this.p = RolePrefixSecurityContextImpl.findPrincipal(subject, rolePrefix);
        this.roles = RolePrefixSecurityContextImpl.findRoles(subject, rolePrefix);
    }

    public Principal getUserPrincipal() {
        return this.p;
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    private static Principal findPrincipal(Subject subject, String rolePrefix) {
        for (Principal p : subject.getPrincipals()) {
            if (p.getName().startsWith(rolePrefix)) continue;
            return p;
        }
        return null;
    }

    private static Set<String> findRoles(Subject subject, String rolePrefix) {
        HashSet<String> set = new HashSet<String>();
        for (Principal p : subject.getPrincipals()) {
            if (!p.getName().startsWith(rolePrefix)) continue;
            set.add(p.getName());
        }
        return set;
    }
}

