/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.jms.interceptor;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.jms.interceptor.JMSFault;
import org.apache.cxf.binding.soap.jms.interceptor.JMSFaultType;
import org.apache.cxf.binding.soap.jms.interceptor.SoapJMSConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

public final class JMSFaultFactory {
    static final Logger LOG = LogUtils.getL7dLogger(JMSFaultFactory.class);

    private JMSFaultFactory() {
    }

    public static JMSFault createContentTypeMismatchFault(String contentType) {
        String m = new Message("CONTENTTYPE_MISMATCH", LOG, contentType).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getContentTypeMismatchQName(), m);
    }

    public static JMSFault createContentEncodingNotSupported(String contentEncoding) {
        String m = new Message("CONTENT_ENCODING_NOT_SUPPORTED", LOG, contentEncoding).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getContentTypeMismatchQName(), m);
    }

    public static JMSFault createMalformedRequestURIFault(String requestURI) {
        String m = new Message("MALFORMED_REQUESTURI", LOG, requestURI).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getMalformedRequestURIQName(), m);
    }

    public static JMSFault createMismatchedSoapActionFault(String soapAction) {
        String m = new Message("MISMATCHED_SOAPACTION", LOG, soapAction).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getMismatchedSoapActionQName(), m);
    }

    public static JMSFault createMissingContentTypeFault() {
        String m = new Message("MISSING_CONTENTTYPE", LOG, new Object[0]).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getMissingContentTypeQName(), m);
    }

    public static JMSFault createMissingRequestURIFault() {
        String m = new Message("MISSING_REQUESTURI", LOG, new Object[0]).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getMissingRequestURIQName(), m);
    }

    public static JMSFault createTargetServiceNotAllowedInRequestURIFault() {
        String m = new Message("TARGET_SERVICE_NOT_ALLOWED_IN_REQUESTURI", LOG, new Object[0]).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getTargetServiceNotAllowedInRequestURIQName(), m);
    }

    public static JMSFault createUnrecognizedBindingVerionFault(String bindingVersion) {
        String m = new Message("UNRECOGNIZED_BINDINGVERSION", LOG, bindingVersion).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getUnrecognizedBindingVersionQName(), m);
    }

    public static JMSFault createUnsupportedJMSMessageFormatFault(String messageFormat) {
        String m = new Message("UNSUPPORTED_JMSMESSAGEFORMAT", LOG, messageFormat).toString();
        return JMSFaultFactory.createFault(SoapJMSConstants.getUnsupportedJMSMessageFormatQName(), m);
    }

    private static JMSFault createFault(QName faultCode, String message) {
        JMSFaultType jmsFaultType = new JMSFaultType();
        jmsFaultType.setFaultCode(faultCode);
        JMSFault jmsFault = new JMSFault(message);
        jmsFault.setJmsFaultType(jmsFaultType);
        jmsFault.setSender(true);
        return jmsFault;
    }
}

