/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.extension.RegistryImpl;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.AssertionBuilderLoader;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.builder.xml.XmlPrimitiveAssertion;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class AssertionBuilderRegistryImpl
extends RegistryImpl<QName, AssertionBuilder>
implements AssertionBuilderRegistry,
BusExtension {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AssertionBuilderRegistryImpl.class);
    private static final Logger LOG = LogUtils.getL7dLogger(AssertionBuilderRegistryImpl.class);
    private static final int IGNORED_CACHE_SIZE = 10;
    private boolean ignoreUnknownAssertions = true;
    private List<QName> ignored = new ArrayList<QName>(10);
    private Bus bus;
    private boolean dynamicLoaded;

    public AssertionBuilderRegistryImpl() {
        super(null);
    }

    public AssertionBuilderRegistryImpl(Bus b) {
        super(null);
        this.setBus(b);
    }

    public AssertionBuilderRegistryImpl(Map<QName, AssertionBuilder> builders) {
        super(builders);
    }

    public AssertionBuilderRegistryImpl(MapProvider<QName, AssertionBuilder> builders) {
        super(builders.createMap());
    }

    public AssertionBuilderRegistryImpl(Bus b, MapProvider<QName, AssertionBuilder> builders) {
        super(builders.createMap());
        this.setBus(b);
    }

    @Resource
    public final void setBus(Bus b) {
        this.bus = b;
        if (b != null) {
            b.setExtension(this, AssertionBuilderRegistry.class);
        }
    }

    @Override
    public Class<?> getRegistrationType() {
        return AssertionBuilderRegistry.class;
    }

    @Override
    public void register(AssertionBuilder builder) {
        Collection<QName> names = builder.getKnownElements();
        for (QName n : names) {
            super.register(n, builder);
        }
    }

    @Override
    public boolean isIgnoreUnknownAssertions() {
        return this.ignoreUnknownAssertions;
    }

    @Override
    public void setIgnoreUnknownAssertions(boolean ignore) {
        this.ignoreUnknownAssertions = ignore;
    }

    private synchronized void loadDynamic() {
        if (!this.dynamicLoaded && this.bus != null) {
            this.dynamicLoaded = true;
            ConfiguredBeanLocator c = this.bus.getExtension(ConfiguredBeanLocator.class);
            if (c != null) {
                c.getBeansOfType(AssertionBuilderLoader.class);
            }
        }
    }

    @Override
    public PolicyAssertion build(Element element) {
        this.loadDynamic();
        QName qname = new QName(element.getNamespaceURI(), element.getLocalName());
        AssertionBuilder builder = (AssertionBuilder)this.get(qname);
        if (null == builder) {
            Message m = new Message("NO_ASSERTIONBUILDER_EXC", BUNDLE, qname.toString());
            if (this.ignoreUnknownAssertions) {
                boolean alreadyWarned = this.ignored.contains(qname);
                if (alreadyWarned) {
                    this.ignored.remove(qname);
                } else if (this.ignored.size() == 10) {
                    this.ignored.remove(9);
                }
                this.ignored.add(0, qname);
                if (!alreadyWarned) {
                    LOG.warning(m.toString());
                }
                return new XmlPrimitiveAssertion(element);
            }
            throw new PolicyException(m);
        }
        return builder.build(element);
    }
}

