/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jbi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.jbi.JBIMessageHelper;
import org.apache.cxf.transport.jbi.JBITransportFactory;

public final class JBIDispatcherUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIDispatcherUtil.class);
    private static JBIDispatcherUtil dispatchUtil;
    private final DeliveryChannel channel;
    private ConduitInitiator conduitInitiator;
    private int activeEndpoints;
    private boolean running;

    private JBIDispatcherUtil(ConduitInitiator ci, DeliveryChannel dc) {
        this.conduitInitiator = ci;
        this.channel = dc;
    }

    public static synchronized JBIDispatcherUtil getInstance(ConduitInitiator ci, DeliveryChannel dc) {
        if (dispatchUtil == null) {
            dispatchUtil = new JBIDispatcherUtil(ci, dc);
        }
        return dispatchUtil;
    }

    public static void clean() {
        dispatchUtil = null;
    }

    public void activateDispatch() {
        ++this.activeEndpoints;
        if (!this.running && this.channel != null) {
            new Thread(new JBIDispatcher()).start();
        }
    }

    public void startDispatch() {
    }

    public void deactivateDispatch() {
        --this.activeEndpoints;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void dispatch(MessageExchange exchange) throws IOException {
        QName opName = exchange.getOperation();
        this.getLogger().fine("dispatch method: " + opName);
        NormalizedMessage nm = exchange.getMessage("in");
        try {
            MessageImpl inMessage = new MessageImpl();
            Set normalizedMessageProps = nm.getPropertyNames();
            for (Object name : normalizedMessageProps) {
                inMessage.put((String)name, nm.getProperty((String)name));
            }
            inMessage.put(MessageExchange.class, (Object)exchange);
            InputStream in = JBIMessageHelper.convertMessageToInputStream(nm.getContent());
            inMessage.setContent(InputStream.class, (Object)in);
            inMessage.setDestination((Destination)((JBITransportFactory)this.conduitInitiator).getDestination(exchange.getService().toString() + exchange.getInterfaceName().toString()));
            ((JBITransportFactory)this.conduitInitiator).getDestination(exchange.getService().toString() + exchange.getInterfaceName().toString()).getMessageObserver().onMessage((Message)inMessage);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.PREPARE.MESSAGE", this.getLogger(), new Object[0]).toString(), ex);
            throw new IOException(ex.getMessage());
        }
    }

    private class JBIDispatcher
    implements Runnable {
        private JBIDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                MessageExchange exchange;
                DeliveryChannel deliveryChannel = JBIDispatcherUtil.this.channel;
                synchronized (deliveryChannel) {
                    JBIDispatcherUtil.this.running = true;
                }
                JBIDispatcherUtil.this.getLogger().fine(new org.apache.cxf.common.i18n.Message("RECEIVE.THREAD.START", JBIDispatcherUtil.this.getLogger(), new Object[0]).toString());
                do {
                    exchange = null;
                    DeliveryChannel deliveryChannel2 = JBIDispatcherUtil.this.channel;
                    synchronized (deliveryChannel2) {
                        try {
                            exchange = JBIDispatcherUtil.this.channel.accept();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (exchange == null || exchange.getStatus() != ExchangeStatus.ACTIVE) continue;
                    JBIDispatcherUtil.this.getLogger().fine(new org.apache.cxf.common.i18n.Message("DISPATCH.TO.SU", JBIDispatcherUtil.this.getLogger(), new Object[0]).toString());
                    JBIDispatcherUtil.this.dispatch(exchange);
                } while (JBIDispatcherUtil.this.activeEndpoints > 0);
                exchange = JBIDispatcherUtil.this.channel;
                synchronized (exchange) {
                    JBIDispatcherUtil.this.running = false;
                }
            }
            catch (Exception ex) {
                JBIDispatcherUtil.this.getLogger().log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.DISPATCH.THREAD", JBIDispatcherUtil.this.getLogger(), new Object[0]).toString(), ex);
            }
            JBIDispatcherUtil.this.getLogger().fine(new org.apache.cxf.common.i18n.Message("JBI.SERVER.TRANSPORT.MESSAGE.PROCESS.THREAD.EXIT", JBIDispatcherUtil.this.getLogger(), new Object[0]).toString());
        }
    }
}

