/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.io.CacheSizeExceededException;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.interceptor.AttachmentInputInterceptor;
import org.apache.cxf.jaxrs.interceptor.AttachmentOutputInterceptor;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContextImpl
implements MessageContext {
    private Message m;

    public MessageContextImpl(Message m) {
        this.m = m;
    }

    @Override
    public Object get(Object key) {
        Message inMessage;
        String keyValue = key.toString();
        if ("org.apache.cxf.jaxrs.attachments.inbound".equals(keyValue) || "org.apache.cxf.jaxrs.attachments.inbound.embedded".equals(keyValue)) {
            try {
                return this.createAttachments(key.toString());
            }
            catch (CacheSizeExceededException e) {
                throw new WebApplicationException(413);
            }
        }
        if (keyValue.equals("WRITE-" + Message.ATTACHMENTS)) {
            return this.m.getExchange().getOutMessage().get((Object)Message.ATTACHMENTS);
        }
        Object value = this.m.get(key);
        if (value == null && MessageUtils.isRequestor((Message)this.m) && (inMessage = this.m.getExchange().getInMessage()) != null) {
            value = inMessage.get(key);
        }
        return value;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        if (MessageUtils.isRequestor((Message)this.m) && this.m.getExchange().getInMessage() != null) {
            Message inMessage = this.m.getExchange().getInMessage();
            return (T)inMessage.getContent(format);
        }
        return (T)this.m.getContent(format);
    }

    @Override
    public Object getContextualProperty(Object key) {
        Object value = this.m.getContextualProperty(key.toString());
        if (value == null && key.getClass() == Class.class) {
            return this.m.getExchange().get((Class)key);
        }
        return value;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        return this.getContext(contextClass, contextClass);
    }

    protected <T> T getContext(Type genericType, Class<T> clazz) {
        return JAXRSUtils.createContextValue(this.m, genericType, clazz);
    }

    @Override
    public <T, E> T getResolver(Class<T> resolverClazz, Class<E> resolveClazz) {
        if (ContextResolver.class == resolverClazz) {
            return resolverClazz.cast(this.getContext(resolveClazz, ContextResolver.class));
        }
        return null;
    }

    @Override
    public Request getRequest() {
        return this.getContext(Request.class);
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.getContext(HttpHeaders.class);
    }

    @Override
    public Providers getProviders() {
        return this.getContext(Providers.class);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.getContext(SecurityContext.class);
    }

    @Override
    public UriInfo getUriInfo() {
        return this.getContext(UriInfo.class);
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.getContext(HttpServletRequest.class);
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.getContext(HttpServletResponse.class);
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.getContext(ServletConfig.class);
    }

    @Override
    public ServletContext getServletContext() {
        return this.getContext(ServletContext.class);
    }

    @Override
    public void put(Object key, Object value) {
        if ("org.apache.cxf.jaxrs.attachments.outbound".equals(key.toString())) {
            this.convertToAttachments(value);
        }
        this.m.put((Object)key.toString(), value);
        if (!MessageUtils.isRequestor((Message)this.m)) {
            this.m.getExchange().put((Object)key.toString(), value);
        }
    }

    private void convertToAttachments(Object value) {
        List handlers = (List)value;
        ArrayList<AttachmentImpl> atts = new ArrayList<AttachmentImpl>();
        for (int i = 1; i < handlers.size(); ++i) {
            Attachment handler = (Attachment)handlers.get(i);
            AttachmentImpl att = new AttachmentImpl(handler.getContentId(), handler.getDataHandler());
            for (String key : handler.getHeaders().keySet()) {
                att.setHeader(key, handler.getHeader(key));
            }
            att.setXOP(false);
            atts.add(att);
        }
        Message outMessage = this.getOutMessage();
        outMessage.setAttachments(atts);
        outMessage.put((Object)"write.attachments", (Object)"true");
        Attachment root = (Attachment)handlers.get(0);
        AttachmentOutputInterceptor attInterceptor = new AttachmentOutputInterceptor(outMessage.get((Object)"Content-Type").toString(), (Map<String, List<String>>)root.getHeaders());
        outMessage.put((Object)"Content-Type", (Object)root.getContentType().toString());
        attInterceptor.handleMessage(outMessage);
    }

    private Message getOutMessage() {
        Message message = this.m.getExchange().getOutMessage();
        if (message == null) {
            Endpoint ep = (Endpoint)this.m.getExchange().get(Endpoint.class);
            message = new MessageImpl();
            message.setExchange(this.m.getExchange());
            message = ep.getBinding().createMessage(message);
            this.m.getExchange().setOutMessage(message);
        }
        return message;
    }

    private MultipartBody createAttachments(String propertyName) {
        Message inMessage = this.m.getExchange().getInMessage();
        boolean embeddedAttachment = inMessage.get((Object)"org.apache.cxf.multipart.embedded") != null;
        Object o = inMessage.get((Object)propertyName);
        if (o != null) {
            return (MultipartBody)o;
        }
        if (embeddedAttachment) {
            inMessage = new MessageImpl();
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.put((Object)"attachment-directory", this.m.getExchange().getInMessage().get((Object)"attachment-directory"));
            inMessage.put((Object)"attachment-memory-threshold", this.m.getExchange().getInMessage().get((Object)"attachment-memory-threshold"));
            inMessage.put((Object)"attachment-max-size", this.m.getExchange().getInMessage().get((Object)"attachment-max-size"));
            inMessage.setContent(InputStream.class, this.m.getExchange().getInMessage().get((Object)"org.apache.cxf.multipart.embedded.input"));
            inMessage.put((Object)"Content-Type", (Object)this.m.getExchange().getInMessage().get((Object)"org.apache.cxf.multipart.embedded.ctype").toString());
        }
        new AttachmentInputInterceptor().handleMessage(inMessage);
        LinkedList<Attachment> newAttachments = new LinkedList<Attachment>();
        try {
            Attachment first = new Attachment(AttachmentUtil.createAttachment((InputStream)((InputStream)inMessage.getContent(InputStream.class)), (InternetHeaders)((InternetHeaders)inMessage.get((Object)InternetHeaders.class.getName()))), new ProvidersImpl(inMessage));
            newAttachments.add(first);
        }
        catch (IOException ex) {
            throw new WebApplicationException(500);
        }
        List<org.apache.cxf.message.Attachment> childAttachments = inMessage.getAttachments();
        if (childAttachments == null) {
            childAttachments = Collections.emptyList();
        }
        childAttachments.size();
        for (org.apache.cxf.message.Attachment a : childAttachments) {
            newAttachments.add(new Attachment(a, new ProvidersImpl(inMessage)));
        }
        MediaType mt = embeddedAttachment ? (MediaType)inMessage.get((Object)"org.apache.cxf.multipart.embedded.ctype") : this.getHttpHeaders().getMediaType();
        MultipartBody body = new MultipartBody(newAttachments, mt, false);
        inMessage.put((Object)propertyName, (Object)body);
        return body;
    }
}

