/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Element;

public class UsernameTokenProcessorWithoutCallbacks
implements Processor {
    private static final Logger LOG = LogUtils.getL7dLogger(UsernameTokenProcessorWithoutCallbacks.class);
    private String utId;
    private UsernameToken ut;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Found UsernameToken list element");
        }
        WSUsernameTokenPrincipal principal = this.handleUsernameToken(elem, cb);
        returnResults.add(0, new WSSecurityEngineResult(1, (Principal)principal, null, null, null));
        this.utId = this.ut.getID();
    }

    private WSUsernameTokenPrincipal handleUsernameToken(Element token, CallbackHandler cb) throws WSSecurityException {
        this.ut = new UsernameToken(token, false);
        String user = this.ut.getName();
        String password = this.ut.getPassword();
        String nonce = this.ut.getNonce();
        String createdTime = this.ut.getCreated();
        String pwType = this.ut.getPasswordType();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("UsernameToken user " + user);
            LOG.fine("UsernameToken password " + password);
        }
        return this.createPrincipal(user, password, this.ut.isHashed(), nonce, createdTime, pwType);
    }

    protected WSUsernameTokenPrincipal createPrincipal(String user, String password, boolean isHashed, String nonce, String createdTime, String pwType) throws WSSecurityException {
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(user, isHashed);
        principal.setNonce(nonce);
        principal.setPassword(password);
        principal.setCreatedTime(createdTime);
        principal.setPasswordType(pwType);
        return principal;
    }

    public String getId() {
        return this.utId;
    }
}

