/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.Alias;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.tools.corba.processors.idl.ArrayVisitor;
import org.apache.cxf.tools.corba.processors.idl.DeclaratorVisitor;
import org.apache.cxf.tools.corba.processors.idl.FixedVisitor;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.SequenceVisitor;
import org.apache.cxf.tools.corba.processors.idl.StringVisitor;
import org.apache.cxf.tools.corba.processors.idl.TypedefDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.TypesVisitor;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public class TypedefVisitor
extends VisitorBase {
    public TypedefVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor) {
        super(scope, defn, schemaRef, wsdlVisitor);
    }

    public static boolean accept(AST node) {
        return node.getType() == 41;
    }

    public void visit(AST typedefNode) {
        AST identifierNode;
        AST typeDeclaratorNode = typedefNode.getFirstChild();
        TypesVisitor typesVisitor = new TypesVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor, identifierNode);
        typesVisitor.visit(typeDeclaratorNode);
        XmlSchemaType schemaType = typesVisitor.getSchemaType();
        CorbaTypeImpl corbaType = typesVisitor.getCorbaType();
        Scope fullyQualifiedName = typesVisitor.getFullyQualifiedName();
        Scope typedefScope = new Scope(this.getScope(), identifierNode);
        if (SequenceVisitor.accept(typeDeclaratorNode) || FixedVisitor.accept(typeDeclaratorNode)) {
            DeclaratorVisitor declaratorVisitor = new DeclaratorVisitor(typedefScope, this.definition, this.schema, this.wsdlVisitor, schemaType, corbaType, fullyQualifiedName);
            declaratorVisitor.visit(identifierNode);
        } else if (StringVisitor.accept(typeDeclaratorNode)) {
            if (StringVisitor.isBounded(typeDeclaratorNode) && !this.wsdlVisitor.getBoundedStringOverride()) {
                DeclaratorVisitor declaratorVisitor = new DeclaratorVisitor(typedefScope, this.definition, this.schema, this.wsdlVisitor, schemaType, corbaType, fullyQualifiedName);
                declaratorVisitor.visit(identifierNode);
            } else {
                for (identifierNode = TypesUtils.getCorbaTypeNameNode(typeDeclaratorNode); identifierNode != null; identifierNode = identifierNode.getNextSibling()) {
                    if (ArrayVisitor.accept(identifierNode)) {
                        ArrayVisitor arrayVisitor = new ArrayVisitor(new Scope(this.getScope(), identifierNode.getText()), this.definition, this.schema, this.wsdlVisitor, identifierNode, fullyQualifiedName);
                        arrayVisitor.setSchemaType(schemaType);
                        arrayVisitor.setCorbaType(corbaType);
                        arrayVisitor.visit(identifierNode);
                        continue;
                    }
                    this.generateStringAlias(typeDeclaratorNode, identifierNode, schemaType, corbaType, fullyQualifiedName);
                }
            }
        } else {
            if (!ArrayVisitor.accept(identifierNode)) {
                this.generateAlias(identifierNode, schemaType, corbaType, fullyQualifiedName);
                corbaType = this.getCorbaType();
            }
            DeclaratorVisitor declaratorVisitor = new DeclaratorVisitor(typedefScope, this.definition, this.schema, this.wsdlVisitor, schemaType, corbaType, fullyQualifiedName);
            declaratorVisitor.visit(identifierNode);
        }
        this.setSchemaType(schemaType);
        this.setCorbaType(corbaType);
        this.setFullyQualifiedName(fullyQualifiedName);
    }

    private void generateAlias(AST identifierNode, XmlSchemaType schemaType, CorbaTypeImpl corbaType, Scope fqName) {
        Scope scopedName = new Scope(this.getScope(), identifierNode);
        Alias alias = new Alias();
        alias.setQName(new QName(this.typeMap.getTargetNamespace(), scopedName.toString()));
        if (corbaType != null || schemaType != null) {
            alias.setBasetype(corbaType.getQName());
        } else {
            this.wsdlVisitor.getDeferredActions().add(fqName, new TypedefDeferredAction(alias));
            scopedNames.add(scopedName);
        }
        alias.setRepositoryID(scopedName.toIDLRepositoryID());
        this.setCorbaType((CorbaTypeImpl)alias);
    }

    private void generateStringAlias(AST typeDeclaratorNode, AST identifierNode, XmlSchemaType schemaType, CorbaTypeImpl corbaType, Scope fqName) {
        Scope typedefScope = new Scope(this.getScope(), identifierNode);
        Alias corbaString = new Alias();
        if (typeDeclaratorNode.getType() == 63) {
            corbaString.setBasetype(CorbaConstants.NT_CORBA_STRING);
        } else if (typeDeclaratorNode.getType() == 64) {
            corbaString.setBasetype(CorbaConstants.NT_CORBA_WSTRING);
        } else {
            throw new RuntimeException("[TypedefVisitor] Attempted to visit an invalid node: " + typeDeclaratorNode.toString());
        }
        Scope newScope = new Scope(typedefScope.getParent(), identifierNode);
        corbaString.setQName(new QName(this.typeMap.getTargetNamespace(), newScope.toString()));
        corbaString.setType(Constants.XSD_STRING);
        corbaString.setRepositoryID(newScope.toIDLRepositoryID());
        this.typeMap.getStructOrExceptionOrUnion().add(corbaString);
    }
}

