/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.http_jetty.spring.JettySpringTypesFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class JettyHTTPServerEngineFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    static final String HTTP_JETTY_NS = "http://cxf.apache.org/transports/http-jetty/configuration";

    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = this.getIdOrName(elem);
        if (StringUtils.isEmpty((String)id)) {
            return JettyHTTPServerEngineFactory.class.getName();
        }
        id = super.resolveId(elem, definition, ctx);
        if (!ctx.getRegistry().containsBeanDefinition(JettyHTTPServerEngineFactory.class.getName())) {
            ctx.getRegistry().registerAlias(id, JettyHTTPServerEngineFactory.class.getName());
        }
        return id;
    }

    public void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String bus = element.getAttribute("bus");
        BeanDefinitionBuilder factbean = BeanDefinitionBuilder.rootBeanDefinition(JettySpringTypesFactory.class);
        ctx.getRegistry().registerBeanDefinition(JettySpringTypesFactory.class.getName(), (BeanDefinition)factbean.getBeanDefinition());
        try {
            if (StringUtils.isEmpty((String)bus)) {
                this.addBusWiringAttribute(bean, BusWiringType.CONSTRUCTOR);
            } else {
                bean.addConstructorArgReference(bus);
            }
            bean.addConstructorArg((Object)this.mapElementToJaxbBean(element, Map.class, JettySpringTypesFactory.class, "createTLSServerParametersMap", new Object[0]));
            bean.addConstructorArg((Object)this.mapElementToJaxbBean(element, Map.class, JettySpringTypesFactory.class, "createThreadingParametersMap", new Object[0]));
            List list = this.getRequiredElementsList(element, ctx, new QName(HTTP_JETTY_NS, "engine"), bean);
            if (list.size() > 0) {
                bean.addPropertyValue("enginesList", (Object)list);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
    }

    private List getRequiredElementsList(Element parent, ParserContext ctx, QName name, BeanDefinitionBuilder bean) {
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)parent, (String)name.getNamespaceURI(), (String)name.getLocalPart());
        ManagedList list = new ManagedList(elemList.size());
        list.setSource(ctx.extractSource((Object)parent));
        for (Element elem : elemList) {
            list.add(ctx.getDelegate().parsePropertySubElement(elem, (BeanDefinition)bean.getBeanDefinition()));
        }
        return list;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected Class getBeanClass(Element arg0) {
        return SpringJettyHTTPServerEngineFactory.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NoJSR250Annotations(unlessNull={"bus"})
    public static class SpringJettyHTTPServerEngineFactory
    extends JettyHTTPServerEngineFactory
    implements ApplicationContextAware {
        public SpringJettyHTTPServerEngineFactory() {
        }

        public SpringJettyHTTPServerEngineFactory(Bus bus, Map<String, TLSServerParameters> tls, Map<String, ThreadingParameters> threading) {
            super(bus, tls, threading);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                Bus bus = BusFactory.getThreadDefaultBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext((Bus)bus, (ApplicationContext)ctx);
                this.setBus(bus);
            }
        }
    }
}

