/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.JarResource;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private static Method springBeanUtilsDescriptorFetcher;
    private static boolean springChecked;

    private ReflectionUtil() {
    }

    public static List<String> getPackagesFromJar(File jarFile) throws IOException {
        ArrayList<String> packageNames = new ArrayList<String>();
        if (jarFile.isDirectory()) {
            ReflectionUtil.getPackageNamesFromDir(jarFile, jarFile, packageNames);
        } else {
            JarResource resource = new JarResource();
            for (String item : resource.getJarContents(jarFile)) {
                String packageName;
                if (!item.endsWith(".class") || StringUtils.isEmpty(packageName = ReflectionUtil.getPackageName(item)) || packageNames.contains(packageName)) continue;
                packageNames.add(packageName);
            }
        }
        return packageNames;
    }

    private static void getPackageNamesFromDir(File base, File dir, List<String> pkgs) {
        boolean foundClass = false;
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                ReflectionUtil.getPackageNamesFromDir(base, file, pkgs);
                continue;
            }
            if (foundClass || !file.getName().endsWith(".class")) continue;
            foundClass = true;
            String pkg = "";
            file = dir;
            while (!file.equals(base)) {
                if (!"".equals(pkg)) {
                    pkg = "." + pkg;
                }
                pkg = file.getName() + pkg;
                file = file.getParentFile();
            }
            if (pkgs.contains(pkg)) continue;
            pkgs.add(pkg);
        }
    }

    private static String getPackageName(String clzName) {
        if (clzName.indexOf("/") == -1) {
            return null;
        }
        String packageName = clzName.substring(0, clzName.lastIndexOf("/"));
        return packageName.replace("/", ".");
    }

    public static PropertyDescriptor[] getPropertyDescriptorsAvoidSunBug(Class<?> refClass, BeanInfo beanInfo, Class<?> beanClass, PropertyDescriptor[] propertyDescriptors) {
        if (!springChecked) {
            try {
                springChecked = true;
                Class<?> cls = ClassLoaderUtils.loadClass("org.springframework.beans.BeanUtils", refClass);
                springBeanUtilsDescriptorFetcher = cls.getMethod("getPropertyDescriptor", Class.class, String.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (springBeanUtilsDescriptorFetcher != null) {
            PropertyDescriptor[] descriptors = null;
            if (propertyDescriptors != null) {
                descriptors = new PropertyDescriptor[propertyDescriptors.length];
                for (int i = 0; i < propertyDescriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                    try {
                        descriptors[i] = (PropertyDescriptor)springBeanUtilsDescriptorFetcher.invoke(null, beanClass, propertyDescriptor.getName());
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return descriptors;
        }
        return beanInfo.getPropertyDescriptors();
    }
}

