/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSClientFactoryBean
extends AbstractJAXRSFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSClientFactoryBean.class);
    private String username;
    private String password;
    private boolean inheritHeaders;
    private MultivaluedMap<String, String> headers;
    private ClientState initialState;
    private boolean threadSafe;
    private Class serviceClass;

    public JAXRSClientFactoryBean() {
        this(new JAXRSServiceFactoryBean());
    }

    public JAXRSClientFactoryBean(JAXRSServiceFactoryBean serviceFactory) {
        super(serviceFactory);
        serviceFactory.setEnableStaticResolution(true);
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInheritHeaders(boolean ih) {
        this.inheritHeaders = ih;
    }

    public void setResourceClass(Class<?> cls) {
        this.setServiceClass(cls);
    }

    public void setServiceClass(Class<?> cls) {
        this.serviceClass = cls;
        this.serviceFactory.setResourceClass(cls);
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = new MetadataMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] values;
            for (String v : values = entry.getValue().split(",")) {
                if (v.length() == 0) continue;
                this.headers.add((Object)entry.getKey(), (Object)v);
            }
        }
    }

    public Map getHeaders() {
        return this.headers;
    }

    public WebClient createWebClient() {
        JAXRSServiceImpl service = new JAXRSServiceImpl(this.getAddress(), this.getServiceName());
        this.getServiceFactory().setService(service);
        try {
            Endpoint ep = this.createEndpoint();
            ClientState actualState = this.getActualState();
            WebClient client = actualState == null ? new WebClient(this.getAddress()) : new WebClient(actualState);
            this.initClient(client, ep, actualState == null);
            return client;
        }
        catch (Exception ex) {
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    private ClientState getActualState() {
        if (this.threadSafe) {
            this.initialState = new ThreadLocalClientState(this.getAddress());
        }
        if (this.initialState != null) {
            return this.headers != null ? this.initialState.newState(URI.create(this.getAddress()), this.headers, null) : this.initialState;
        }
        return null;
    }

    public <T> T create(Class<T> cls, Object ... varValues) {
        return cls.cast(this.createWithValues(varValues));
    }

    public Client create() {
        return this.createWithValues(new Object[0]);
    }

    public Client createWithValues(Object ... varValues) {
        this.serviceFactory.setBus(this.getBus());
        this.checkResources(false);
        AbstractResourceInfo cri = null;
        try {
            Endpoint ep = this.createEndpoint();
            if (this.getServiceClass() != null) {
                for (ClassResourceInfo info : this.serviceFactory.getClassResourceInfo()) {
                    if (!info.getServiceClass().isAssignableFrom(this.getServiceClass()) && !this.getServiceClass().isAssignableFrom(info.getServiceClass())) continue;
                    cri = info;
                    break;
                }
                if (cri == null) {
                    throw new RuntimeException("Service class " + this.getServiceClass().getName() + " is not recognized");
                }
            } else {
                cri = this.serviceFactory.getClassResourceInfo().get(0);
            }
            boolean isRoot = ((ClassResourceInfo)cri).getURITemplate() != null;
            ClientProxyImpl proxyImpl = null;
            ClientState actualState = this.getActualState();
            proxyImpl = actualState == null ? new ClientProxyImpl(URI.create(this.getAddress()), (ClassResourceInfo)cri, isRoot, this.inheritHeaders, varValues) : new ClientProxyImpl(actualState, (ClassResourceInfo)cri, isRoot, this.inheritHeaders, varValues);
            this.initClient(proxyImpl, ep, actualState == null);
            try {
                return (Client)ProxyHelper.getProxy(cri.getServiceClass().getClassLoader(), new Class[]{cri.getServiceClass(), Client.class, InvocationHandlerAware.class}, proxyImpl);
            }
            catch (Exception ex) {
                return (Client)ProxyHelper.getProxy(Thread.currentThread().getContextClassLoader(), new Class[]{cri.getServiceClass(), Client.class, InvocationHandlerAware.class}, proxyImpl);
            }
        }
        catch (IllegalArgumentException ex) {
            String expected;
            String message = ex.getLocalizedMessage();
            if (cri != null && ((expected = cri.getServiceClass().getSimpleName()) + " is not an interface").equals(message)) {
                message = message + "; make sure CGLIB is on the classpath";
            }
            LOG.severe(ex.getClass().getName() + " : " + message);
            throw ex;
        }
        catch (Exception ex) {
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    protected ConduitSelector getConduitSelector(Endpoint ep) {
        ConduitSelector cs = this.getConduitSelector();
        cs = cs == null ? new UpfrontConduitSelector() : cs;
        cs.setEndpoint(ep);
        return cs;
    }

    protected void initClient(AbstractClient client, Endpoint ep, boolean addHeaders) {
        if (this.username != null) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(this.username);
            authPolicy.setPassword(this.password);
            ep.getEndpointInfo().addExtensor(authPolicy);
        }
        this.applyFeatures(client);
        client.getConfiguration().setConduitSelector(this.getConduitSelector(ep));
        client.getConfiguration().setBus(this.getBus());
        client.getConfiguration().getOutInterceptors().addAll(this.getOutInterceptors());
        client.getConfiguration().getOutInterceptors().addAll(ep.getOutInterceptors());
        client.getConfiguration().getInInterceptors().addAll(this.getInInterceptors());
        client.getConfiguration().getInInterceptors().addAll(ep.getInInterceptors());
        if (this.headers != null && addHeaders) {
            client.headers(this.headers);
        }
        this.setupFactory(ep);
    }

    protected void applyFeatures(AbstractClient client) {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(client.getConfiguration(), this.getBus());
            }
        }
    }

    public void setInitialState(ClientState initialState) {
        this.initialState = initialState;
    }
}

