/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;

public class UsernameTokenPolicyValidator
extends AbstractTokenPolicyValidator {
    private Message message;

    public UsernameTokenPolicyValidator(Message message) {
        this.message = message;
    }

    public boolean validatePolicy(AssertionInfoMap aim, WSSecurityEngineResult wser) {
        Collection utAis = (Collection)aim.get((Object)SP12Constants.USERNAME_TOKEN);
        if (utAis != null && !utAis.isEmpty()) {
            for (AssertionInfo ai : utAis) {
                org.apache.ws.security.message.token.UsernameToken usernameToken = (org.apache.ws.security.message.token.UsernameToken)wser.get((Object)"username-token");
                UsernameToken usernameTokenPolicy = (UsernameToken)ai.getAssertion();
                ai.setAsserted(true);
                boolean tokenRequired = this.isTokenRequired(usernameTokenPolicy, this.message);
                if (tokenRequired && usernameToken == null || !tokenRequired && usernameToken != null) {
                    ai.setNotAsserted("The received token does not match the token inclusion requirement");
                    return false;
                }
                if (!tokenRequired) continue;
                if (usernameTokenPolicy.isHashPassword() != usernameToken.isHashed()) {
                    ai.setNotAsserted("Password hashing policy not enforced");
                    return false;
                }
                if (usernameTokenPolicy.isNoPassword() && usernameToken.getPassword() != null) {
                    ai.setNotAsserted("Username Token NoPassword policy not enforced");
                    return false;
                }
                if (usernameTokenPolicy.isRequireCreated() && (usernameToken.getCreated() == null || usernameToken.isHashed())) {
                    ai.setNotAsserted("Username Token Created policy not enforced");
                    return false;
                }
                if (!usernameTokenPolicy.isRequireNonce() || usernameToken.getNonce() != null && !usernameToken.isHashed()) continue;
                ai.setNotAsserted("Username Token Nonce policy not enforced");
                return false;
            }
        }
        return true;
    }
}

