/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Reference {
    public static final QName TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
    protected Element element = null;

    public Reference(Element elem) throws WSSecurityException {
        if (elem == null) {
            throw new WSSecurityException(3, "noReference");
        }
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(0, "badElement", new Object[]{TOKEN, el});
        }
        String uri = this.getURI();
        if (uri == null || "".equals(uri)) {
            throw new WSSecurityException(3, "badReferenceURI");
        }
    }

    public Reference(Document doc) {
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
    }

    public void addWSSENamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
    }

    public Element getElement() {
        return this.element;
    }

    public String getValueType() {
        return this.element.getAttribute("ValueType");
    }

    public String getURI() {
        return this.element.getAttribute("URI");
    }

    public void setValueType(String valueType) {
        this.element.setAttributeNS(null, "ValueType", valueType);
    }

    public void setURI(String uri) {
        this.element.setAttributeNS(null, "URI", uri);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }
}

