/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.Exception;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.ArrayVisitor;
import org.apache.cxf.tools.corba.processors.idl.ExceptionDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.TypesVisitor;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class ExceptionVisitor
extends VisitorBase {
    private static final String TYPE_SUFFIX = "Type";

    public ExceptionVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlASTVisitor) {
        super(scope, defn, schemaRef, wsdlASTVisitor);
    }

    public static boolean accept(AST node) {
        return node.getType() == 67;
    }

    public void visit(AST node) {
        AST identifierNode = node.getFirstChild();
        Scope exceptionScope = new Scope(this.getScope(), identifierNode);
        Scope scopedName = new Scope(this.getScope(), identifierNode);
        String exceptionName = this.mapper.mapToQName(scopedName);
        XmlSchemaElement element = new XmlSchemaElement(this.schema, true);
        element.setName(this.mapper.mapToQName(scopedName));
        String exceptionTypeName = exceptionName + TYPE_SUFFIX;
        XmlSchemaComplexType complexType = new XmlSchemaComplexType(this.schema, true);
        complexType.setName(exceptionTypeName);
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        complexType.setParticle((XmlSchemaParticle)sequence);
        element.setSchemaTypeName(complexType.getQName());
        Exception exception = new Exception();
        exception.setQName(new QName(this.typeMap.getTargetNamespace(), exceptionName));
        exception.setType(complexType.getQName());
        exception.setRepositoryID(scopedName.toIDLRepositoryID());
        AST memberTypeNode = identifierNode.getNextSibling();
        while (memberTypeNode != null) {
            AST memberNode = memberTypeNode.getNextSibling();
            TypesVisitor visitor = new TypesVisitor(exceptionScope, this.definition, this.schema, this.wsdlVisitor, null);
            visitor.visit(memberTypeNode);
            XmlSchemaType stype = visitor.getSchemaType();
            CorbaTypeImpl ctype = visitor.getCorbaType();
            Scope fullyQualifiedName = visitor.getFullyQualifiedName();
            if (ArrayVisitor.accept(memberNode)) {
                Scope anonScope = new Scope(exceptionScope, TypesUtils.getCorbaTypeNameNode(memberTypeNode));
                ArrayVisitor arrayVisitor = new ArrayVisitor(anonScope, this.definition, this.schema, this.wsdlVisitor, null, fullyQualifiedName);
                arrayVisitor.setSchemaType(stype);
                arrayVisitor.setCorbaType(ctype);
                arrayVisitor.visit(memberNode);
                stype = arrayVisitor.getSchemaType();
                ctype = arrayVisitor.getCorbaType();
            }
            XmlSchemaElement member = this.createElementType(memberNode, stype, fullyQualifiedName);
            sequence.getItems().add(member);
            MemberType memberType = this.createMemberType(memberNode, ctype, fullyQualifiedName);
            exception.getMember().add(memberType);
            memberTypeNode = memberNode.getNextSibling();
        }
        this.typeMap.getStructOrExceptionOrUnion().add(exception);
        this.setSchemaType((XmlSchemaType)complexType);
        this.setCorbaType((CorbaTypeImpl)exception);
        this.createFaultMessage(element.getQName());
    }

    private void createFaultMessage(QName qname) {
        String exceptionName = qname.getLocalPart();
        Message faultMsg = this.definition.createMessage();
        faultMsg.setQName(new QName(this.definition.getTargetNamespace(), exceptionName));
        faultMsg.setUndefined(false);
        Part part = this.definition.createPart();
        part.setName("exception");
        part.setElementName(qname);
        faultMsg.addPart(part);
        String nsURI = qname.getNamespaceURI();
        this.manager.addWSDLDefinitionNamespace(this.definition, this.mapper.mapNSToPrefix(nsURI), nsURI);
        this.definition.addMessage(faultMsg);
    }

    private XmlSchemaElement createElementType(AST memberNode, XmlSchemaType stype, Scope fqName) {
        XmlSchemaElement member = new XmlSchemaElement(this.schema, false);
        String memberName = memberNode.toString();
        member.setName(memberName);
        if (stype != null) {
            member.setSchemaType(stype);
            member.setSchemaTypeName(stype.getQName());
            if (stype.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                member.setNillable(true);
            }
        } else {
            this.wsdlVisitor.getDeferredActions().add(fqName, new ExceptionDeferredAction(member));
        }
        return member;
    }

    private MemberType createMemberType(AST memberNode, CorbaTypeImpl ctype, Scope fqName) {
        MemberType memberType = new MemberType();
        memberType.setName(memberNode.toString());
        if (ctype != null) {
            memberType.setIdltype(ctype.getQName());
        } else {
            this.wsdlVisitor.getDeferredActions().add(fqName, new ExceptionDeferredAction(memberType));
        }
        return memberType;
    }
}

