/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.message.token.KerberosServiceAction;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;

public class KerberosTokenValidator
implements Validator {
    private static Log log = LogFactory.getLog(KerberosTokenValidator.class);
    private String serviceName;
    private CallbackHandler callbackHandler;
    private String jaasLoginModuleName;

    public String getJaasLoginModuleName() {
        return this.jaasLoginModuleName;
    }

    public void setJaasLoginModuleName(String jaasLoginModuleName) {
        this.jaasLoginModuleName = jaasLoginModuleName;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        KerberosServiceAction action;
        Principal principal;
        if (credential == null || credential.getBinarySecurityToken() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        BinarySecurity binarySecurity = credential.getBinarySecurityToken();
        if (!(binarySecurity instanceof KerberosSecurity)) {
            return credential;
        }
        if (log.isDebugEnabled()) {
            try {
                String jaasAuth = System.getProperty("java.security.auth.login.config");
                String krbConf = System.getProperty("java.security.krb5.conf");
                log.debug((Object)("KerberosTokenValidator - Using JAAS auth login file: " + jaasAuth));
                log.debug((Object)("KerberosTokenValidator - Using KRB conf file: " + krbConf));
            }
            catch (SecurityException ex) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        LoginContext loginContext = null;
        try {
            loginContext = this.callbackHandler == null ? new LoginContext(this.jaasLoginModuleName) : new LoginContext(this.jaasLoginModuleName, this.callbackHandler);
            loginContext.login();
        }
        catch (LoginException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{ex.getMessage()});
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully authenticated to the TGT");
        }
        byte[] token = binarySecurity.getToken();
        Subject subject = loginContext.getSubject();
        String service = this.serviceName;
        if (service == null) {
            Set<Principal> principals = subject.getPrincipals();
            if (principals.isEmpty()) {
                throw new WSSecurityException(0, "kerberosLoginError", new Object[]{"No Client principals found after login"});
            }
            service = principals.iterator().next().getName();
        }
        if ((principal = Subject.doAs(subject, action = new KerberosServiceAction(token, service))) == null) {
            throw new WSSecurityException(0, "kerberosTicketValidationError");
        }
        credential.setPrincipal(principal);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully validated a ticket");
        }
        return credential;
    }
}

