/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.sdo.DataReaderImpl;
import org.apache.cxf.sdo.DataWriterImpl;
import org.apache.cxf.sdo.NodeDataWriterImpl;
import org.apache.cxf.sdo.SDOClassCollector;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.tuscany.sdo.api.SDOUtil;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDODataBinding
extends AbstractDataBinding
implements WrapperCapableDatabinding {
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{XMLStreamWriter.class, Node.class};
    HelperProvider provider;
    HelperContext context;

    @Override
    public void initialize(Service service) {
        this.context = SDOUtil.createHelperContext();
        HashSet<String> pkgs = new HashSet<String>();
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            SDOClassCollector cc = new SDOClassCollector(serviceInfo);
            cc.walk();
            for (Class<?> cls : cc.getClasses()) {
                String pkg;
                if (DataObject.class == cls || pkgs.contains(pkg = cls.getPackage().getName())) continue;
                try {
                    Class<?> fact = Class.forName(pkg + ".SdoFactory", false, cls.getClassLoader());
                    this.registerFactory(fact);
                    pkgs.add(pkg);
                }
                catch (Throwable t) {
                    this.register(cls);
                }
            }
        }
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            for (XmlSchema schema : serviceInfo.getXmlSchemaCollection().getXmlSchemas()) {
                if (schema.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) continue;
                StringWriter writer = new StringWriter();
                schema.write((Writer)writer);
                this.context.getXSDHelper().define((Reader)new StringReader(writer.toString()), schema.getSourceURI());
            }
        }
    }

    void registerFactory(Class<?> factoryClass) throws Exception {
        Field field = factoryClass.getField("INSTANCE");
        Object factory = field.get(null);
        Method method = factory.getClass().getMethod("register", HelperContext.class);
        method.invoke(factory, this.context);
    }

    boolean register(Class javaType) {
        if (javaType == null || DataObject.class == javaType) {
            return false;
        }
        try {
            Type type = this.context.getTypeHelper().getType(javaType);
            if (type != null && !type.isDataType()) {
                Method method = type.getClass().getMethod("getEPackage", new Class[0]);
                Object factory = method.invoke((Object)type, new Object[0]);
                method = factory.getClass().getMethod("register", HelperContext.class);
                method.invoke(factory, this.context);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public <T> DataReader<T> createReader(Class<T> c) {
        DataReaderImpl dr = null;
        if (c == XMLStreamReader.class) {
            dr = new DataReaderImpl(this.context);
        }
        return dr;
    }

    @Override
    public <T> DataWriter<T> createWriter(Class<T> c) {
        if (c == XMLStreamWriter.class) {
            return new DataWriterImpl(this.context);
        }
        if (c == Node.class) {
            return new NodeDataWriterImpl(this.context);
        }
        return null;
    }

    @Override
    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_READER_FORMATS;
    }

    @Override
    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_WRITER_FORMATS;
    }

    @Override
    public WrapperHelper createWrapperHelper(Class<?> wrapperType, QName wrapperName, List<String> partNames, List<String> elTypeNames, List<Class<?>> partClasses) {
        return new SDOWrapperHelper(partNames, wrapperType, wrapperName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SDOWrapperHelper
    implements WrapperHelper {
        private final List<String> partNames;
        private Method fact;
        private Object factory;
        private QName wrapperName;

        private SDOWrapperHelper(List<String> partNames, Class<?> wrapperType, QName wrapperName) {
            this.partNames = partNames;
            if (DataObject.class != wrapperType) {
                try {
                    String s = wrapperType.getPackage().getName() + ".SdoFactory";
                    Class<?> cls = Class.forName(s, false, wrapperType.getClassLoader());
                    for (Method m : cls.getMethods()) {
                        if (m.getReturnType() != wrapperType) continue;
                        this.fact = m;
                        break;
                    }
                    this.factory = cls.getField("INSTANCE").get(null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.wrapperName = wrapperName;
        }

        @Override
        public Object createWrapperObject(List<?> lst) throws Fault {
            DataObject o;
            if (this.fact != null) {
                try {
                    o = (DataObject)this.fact.invoke(this.factory, new Object[0]);
                }
                catch (Exception e) {
                    throw new Fault(e);
                }
            } else {
                o = SDODataBinding.this.context.getDataFactory().create(this.wrapperName.getNamespaceURI(), this.wrapperName.getLocalPart());
            }
            for (int x = 0; x < lst.size(); ++x) {
                o.set(this.partNames.get(x), lst.get(x));
            }
            return o;
        }

        @Override
        public String getSignature() {
            return "" + System.identityHashCode(this);
        }

        @Override
        public List<Object> getWrapperParts(Object o) throws Fault {
            ArrayList<Object> lst = new ArrayList<Object>();
            DataObject obj = (DataObject)o;
            for (String s : this.partNames) {
                lst.add(obj.get(s));
            }
            return lst;
        }
    }
}

