/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.relax.core.checker;

import com.sun.msv.datatype.xsd.IDREFType;
import com.sun.msv.datatype.xsd.IDType;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.relax.AttPoolClause;
import com.sun.msv.grammar.relax.ElementRules;
import com.sun.msv.grammar.relax.HedgeRules;
import com.sun.msv.grammar.relax.RELAXExpressionVisitorVoid;
import com.sun.msv.grammar.relax.RELAXModule;
import com.sun.msv.grammar.relax.TagClause;
import com.sun.msv.reader.relax.core.RELAXCoreReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.relaxng.datatype.Datatype;

public class IdAbuseChecker
implements RELAXExpressionVisitorVoid {
    private final Set<String> tagNames = new HashSet<String>();
    private final Set<String> overloadedNames = new HashSet<String>();
    private final Set<String> nonIdAttrNames = new HashSet<String>();
    private final Set<AttributeExp> idAttributes = new HashSet<AttributeExp>();
    private final RELAXModule module;
    private final RELAXCoreReader reader;
    private String currentTagName;

    private IdAbuseChecker(RELAXCoreReader r, RELAXModule m) {
        this.reader = r;
        this.module = m;
    }

    public static void check(RELAXCoreReader reader, RELAXModule module) {
        new IdAbuseChecker(reader, module).run();
    }

    private void run() {
        TagClause tag;
        Iterator<Expression> itr = this.module.tags.iterator();
        while (itr.hasNext()) {
            tag = (TagClause)itr.next();
            if (!(tag.nameClass instanceof SimpleNameClass)) continue;
            SimpleNameClass snc = (SimpleNameClass)tag.nameClass;
            if (this.tagNames.contains(snc.localName)) {
                this.overloadedNames.add(snc.localName);
                continue;
            }
            this.tagNames.add(snc.localName);
        }
        itr = this.module.tags.iterator();
        while (itr.hasNext()) {
            tag = (TagClause)itr.next();
            this.currentTagName = tag.nameClass instanceof SimpleNameClass ? ((SimpleNameClass)tag.nameClass).localName : null;
            tag.exp.visit(this);
        }
        for (AttributeExp atr : this.idAttributes) {
            if (atr.nameClass instanceof SimpleNameClass) {
                String name = ((SimpleNameClass)atr.nameClass).localName;
                if (!this.nonIdAttrNames.contains(name)) continue;
                this.reader.reportError("RELAXReader.IdAbuse.1", (Object)name);
                continue;
            }
            this.reader.reportError("RELAXReader.IdAbuse");
        }
    }

    public void onAttribute(AttributeExp exp) {
        if (!(exp.nameClass instanceof SimpleNameClass)) {
            return;
        }
        Expression body = exp.exp.getExpandedExp(this.reader.pool);
        if (!(body instanceof DataExp)) {
            return;
        }
        SimpleNameClass snc = (SimpleNameClass)exp.nameClass;
        if (!snc.namespaceURI.equals("")) {
            return;
        }
        Datatype dt = ((DataExp)body).dt;
        if (dt == IDType.theInstance || dt == IDREFType.theInstance) {
            if (this.currentTagName == null || this.overloadedNames.contains(this.currentTagName)) {
                this.idAttributes.add(exp);
            }
        } else {
            this.nonIdAttrNames.add(snc.localName);
        }
    }

    public void onChoice(ChoiceExp exp) {
        exp.exp1.visit(this);
        exp.exp2.visit(this);
    }

    public void onElement(ElementExp exp) {
        throw new Error();
    }

    public void onOneOrMore(OneOrMoreExp exp) {
        exp.exp.visit(this);
    }

    public void onMixed(MixedExp exp) {
        throw new Error();
    }

    public void onRef(ReferenceExp exp) {
        exp.exp.visit(this);
    }

    public void onOther(OtherExp exp) {
        exp.exp.visit(this);
    }

    public void onEpsilon() {
    }

    public void onNullSet() {
    }

    public void onAnyString() {
    }

    public void onSequence(SequenceExp exp) {
    }

    public void onData(DataExp exp) {
        throw new Error();
    }

    public void onValue(ValueExp exp) {
        throw new Error();
    }

    public void onAttPool(AttPoolClause exp) {
        exp.exp.visit(this);
    }

    public void onTag(TagClause exp) {
        throw new Error();
    }

    public void onElementRules(ElementRules exp) {
        throw new Error();
    }

    public void onHedgeRules(HedgeRules exp) {
        throw new Error();
    }

    public void onInterleave(InterleaveExp exp) {
        throw new Error();
    }

    public void onConcur(ConcurExp exp) {
        throw new Error();
    }

    public void onList(ListExp exp) {
        throw new Error();
    }
}

