/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.kerberos;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.token.KerberosSecurity;

public class KerberosClient
implements Configurable {
    private static final Logger LOG = LogUtils.getL7dLogger(KerberosClient.class);
    Bus bus;
    String name = "default.kerberos-client";
    private String serviceName;
    private CallbackHandler callbackHandler;
    private String jaasLoginModuleName;
    private WSSConfig wssConfig = WSSConfig.getNewInstance();

    public KerberosClient(Bus b) {
        this.bus = b;
    }

    public String getBeanName() {
        return this.name;
    }

    public String getJaasLoginModuleName() {
        return this.jaasLoginModuleName;
    }

    public void setJaasLoginModuleName(String jaasLoginModuleName) {
        this.jaasLoginModuleName = jaasLoginModuleName;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public SecurityToken requestSecurityToken() throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Requesting Kerberos ticket for " + this.serviceName + " using JAAS Login Module: " + this.jaasLoginModuleName);
        }
        KerberosSecurity bst = new KerberosSecurity(DOMUtils.createDocument());
        bst.retrieveServiceTicket(this.jaasLoginModuleName, this.callbackHandler, this.serviceName);
        bst.addWSUNamespace();
        bst.setID(this.wssConfig.getIdAllocator().createSecureId("BST-", (Object)bst));
        SecurityToken token = new SecurityToken(bst.getID());
        token.setToken(bst.getElement());
        token.setTokenType(bst.getValueType());
        return token;
    }
}

