/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

import org.apache.xmlbeans.XmlObject;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;

/**
 * JSON provider for XMLBeans data objects.
 */
@Produces("application/json")
@Consumes("application/json")
@Provider
public class XMLBeansJSONProvider extends XMLBeansElementProvider {

    /** {@inheritDoc} */
    @Override
    public XmlObject readFrom(Class<XmlObject> type, Type genericType, 
                              Annotation[] annotations, MediaType m, 
        MultivaluedMap<String, String> headers, InputStream is)
        throws IOException {
        XmlObject result = null;

        try {

            Map<String, String> nstojns = new HashMap<String, String>();

            MappedXMLInputFactory factory = new MappedXMLInputFactory(nstojns);
            XMLStreamReader xsr = factory.createXMLStreamReader(is);
            Reader r = (Reader)xsr;
            result = parseXmlBean(type, r);

            xsr.close();
            result = null;

        } catch (XMLStreamException e) {
            throw new WebApplicationException(HttpURLConnection.HTTP_INTERNAL_ERROR);
        }

        return result;
    }

    /** {@inheritDoc} */
    @Override
    public void writeTo(XmlObject obj, Class<?> cls, Type genericType, Annotation[] annotations,  
                        MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) {

        try {

            // Set up the JSON StAX implementation
            Map<String, String> nstojns = new HashMap<String, String>();
            XMLOutputFactory factory = new MappedXMLOutputFactory(nstojns);
            XMLStreamWriter xsw = factory.createXMLStreamWriter(os);
            xsw.writeStartDocument();
            if (obj instanceof XmlObject) {

                XmlObject xObj = (XmlObject)obj;
                XMLBeanStreamSerializer ser = new XMLBeanStreamSerializer();
                ser.serialize(xObj, xsw);
            }

            xsw.flush();
            xsw.close();

        } catch (XMLStreamException e) {
            throw new WebApplicationException(HttpURLConnection.HTTP_INTERNAL_ERROR);
        } catch (IOException ioe) {
            throw new WebApplicationException(HttpURLConnection.HTTP_INTERNAL_ERROR);
        }
    }
}
