/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SecurityContextToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextTokenBuilder
implements AssertionBuilder<Element> {
    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SECURITY_CONTEXT_TOKEN, SP12Constants.SECURITY_CONTEXT_TOKEN};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SecurityContextToken contextToken = new SecurityContextToken(consts);
        String includeAttr = DOMUtils.getAttribute((Element)element, (QName)consts.getIncludeToken());
        if (includeAttr != null) {
            contextToken.setInclusion(consts.getInclusionFromAttributeValue(includeAttr));
        }
        if ((element = PolicyConstants.findPolicyElement((Element)element)) != null) {
            if (DOMUtils.getFirstChildWithName((Element)element, (String)consts.getNamespace(), (String)"RequireDerivedKeys") != null) {
                contextToken.setDerivedKeys(true);
            }
            if (DOMUtils.getFirstChildWithName((Element)element, (String)consts.getNamespace(), (String)"RequireExternalUriReference") != null) {
                contextToken.setRequireExternalUriRef(true);
            }
            if (DOMUtils.getFirstChildWithName((Element)element, (String)consts.getNamespace(), (String)"SC10SecurityContextToken") != null) {
                contextToken.setSc10SecurityContextToken(true);
            }
        }
        return contextToken;
    }
}

