/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.xml.namespace.QName;
import org.apache.ws.security.CustomTokenPrincipal;
import org.apache.ws.security.SAMLTokenPrincipal;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.str.BSPEnforcer;
import org.apache.ws.security.str.STRParser;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureSTRParser
implements STRParser {
    public static final String SIGNATURE_METHOD = "signature_method";
    public static final String SECRET_KEY_LENGTH = "secret_key_length";
    private X509Certificate[] certs;
    private byte[] secretKey;
    private PublicKey publicKey;
    private Principal principal;
    private boolean trustedCredential;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        WSSecurityEngineResult result;
        boolean bspCompliant = true;
        Crypto crypto = data.getSigCrypto();
        if (data.getWssConfig() != null) {
            bspCompliant = data.getWssConfig().isWsiBSPCompliant();
        }
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, bspCompliant);
        String uri = null;
        if (secRef.containsReference()) {
            uri = secRef.getReference().getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
        } else if (secRef.containsKeyIdentifier()) {
            uri = secRef.getKeyIdentifierValue();
        }
        if ((result = wsDocInfo.getResult(uri)) != null) {
            this.processPreviousResult(result, secRef, data, parameters, bspCompliant);
        } else if (secRef.containsReference()) {
            Element token = secRef.getTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler());
            QName el = new QName(token.getNamespaceURI(), token.getLocalName());
            if (el.equals(WSSecurityEngine.BINARY_TOKEN)) {
                this.certs = SignatureSTRParser.getCertificatesTokenReference(secRef, token, crypto, bspCompliant);
            } else if (el.equals(WSSecurityEngine.SAML_TOKEN) || el.equals(WSSecurityEngine.SAML2_TOKEN)) {
                SAMLKeyInfo keyInfo;
                X509Certificate[] foundCerts;
                Processor proc = data.getWssConfig().getProcessor(WSSecurityEngine.SAML_TOKEN);
                Element processedToken = secRef.findProcessedTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler(), uri, secRef.getReference().getValueType());
                AssertionWrapper assertion = null;
                if (processedToken == null) {
                    List<WSSecurityEngineResult> samlResult = proc.handleToken(token, data, wsDocInfo);
                    assertion = (AssertionWrapper)samlResult.get(0).get("saml-assertion");
                } else {
                    assertion = new AssertionWrapper(processedToken);
                    assertion.parseHOKSubject(data, wsDocInfo);
                }
                if (bspCompliant) {
                    BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
                }
                if ((foundCerts = (keyInfo = assertion.getSubjectKeyInfo()).getCerts()) != null) {
                    this.certs = new X509Certificate[]{foundCerts[0]};
                }
                this.secretKey = keyInfo.getSecret();
                this.principal = this.createPrincipalFromSAML(assertion);
            } else if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                if (bspCompliant) {
                    BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
                }
                Processor proc = data.getWssConfig().getProcessor(WSSecurityEngine.ENCRYPTED_KEY);
                List<WSSecurityEngineResult> encrResult = proc.handleToken(token, data, wsDocInfo);
                this.secretKey = (byte[])encrResult.get(0).get("secret");
                this.principal = new CustomTokenPrincipal(token.getAttribute("Id"));
            } else {
                String id = secRef.getReference().getURI();
                this.secretKey = this.getSecretKeyFromToken(id, null, data);
                this.principal = new CustomTokenPrincipal(id);
            }
        } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
            X509Certificate[] foundCerts = secRef.getX509IssuerSerial(crypto);
            if (foundCerts != null) {
                this.certs = new X509Certificate[]{foundCerts[0]};
            }
        } else if (secRef.containsKeyIdentifier()) {
            if (secRef.getKeyIdentifierValueType().equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1")) {
                if (bspCompliant) {
                    BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
                }
                String id = secRef.getKeyIdentifierValue();
                this.secretKey = this.getSecretKeyFromToken(id, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1", data);
                this.principal = new CustomTokenPrincipal(id);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(secRef.getKeyIdentifierValueType())) {
                SAMLKeyInfo samlKi;
                X509Certificate[] foundCerts;
                AssertionWrapper assertion = SAMLUtil.getAssertionFromKeyIdentifier(secRef, strElement, data, wsDocInfo);
                if (bspCompliant) {
                    BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
                }
                if ((foundCerts = (samlKi = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant)).getCerts()) != null) {
                    this.certs = new X509Certificate[]{foundCerts[0]};
                }
                this.secretKey = samlKi.getSecret();
                this.publicKey = samlKi.getPublicKey();
                this.principal = this.createPrincipalFromSAML(assertion);
            } else {
                X509Certificate[] foundCerts;
                if (bspCompliant) {
                    BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, null);
                }
                if ((foundCerts = secRef.getKeyIdentifier(crypto)) != null) {
                    this.certs = new X509Certificate[]{foundCerts[0]};
                }
            }
        } else {
            throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{strElement.toString()});
        }
        if (this.certs != null && this.principal == null) {
            this.principal = this.certs[0].getSubjectX500Principal();
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean isTrustedCredential() {
        return this.trustedCredential;
    }

    private static X509Certificate[] getCertificatesTokenReference(SecurityTokenReference secRef, Element elem, Crypto crypto, boolean bspCompliant) throws WSSecurityException {
        if (crypto == null) {
            throw new WSSecurityException(0, "noSigCryptoFile");
        }
        BinarySecurity token = SignatureSTRParser.createSecurityToken(elem, bspCompliant);
        if (bspCompliant) {
            BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, token);
        }
        if (token instanceof PKIPathSecurity) {
            return ((PKIPathSecurity)token).getX509Certificates(crypto);
        }
        X509Certificate cert = ((X509Security)token).getX509Certificate(crypto);
        return new X509Certificate[]{cert};
    }

    private static BinarySecurity createSecurityToken(Element element, boolean bspCompliant) throws WSSecurityException {
        String type = element.getAttribute("ValueType");
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(type)) {
            X509Security x509 = new X509Security(element, bspCompliant);
            return x509;
        }
        if (PKIPathSecurity.getType().equals(type)) {
            PKIPathSecurity pkiPath = new PKIPathSecurity(element, bspCompliant);
            return pkiPath;
        }
        throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{type});
    }

    private Principal createPrincipalFromSAML(AssertionWrapper assertion) {
        SAMLTokenPrincipal principal = new SAMLTokenPrincipal(assertion);
        String confirmMethod = null;
        List<String> methods = assertion.getConfirmationMethods();
        if (methods != null && methods.size() > 0) {
            confirmMethod = methods.get(0);
        }
        if (OpenSAMLUtil.isMethodHolderOfKey(confirmMethod) && assertion.isSigned()) {
            this.trustedCredential = true;
        }
        return principal;
    }

    private byte[] getSecretKeyFromToken(String id, String type, RequestData data) throws WSSecurityException {
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(id, null, type, 9, data);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            data.getCallbackHandler().handle(callbacks);
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
        }
        return pwcb.getKey();
    }

    private void processPreviousResult(WSSecurityEngineResult result, SecurityTokenReference secRef, RequestData data, Map<String, Object> parameters, boolean bspCompliant) throws WSSecurityException {
        int action = (Integer)result.get("action");
        if (8192 == action || 1 == action) {
            if (bspCompliant) {
                BSPEnforcer.checkUsernameTokenBSPCompliance(secRef);
            }
            UsernameToken usernameToken = (UsernameToken)result.get("username-token");
            usernameToken.setRawPassword(data);
            if (usernameToken.isDerivedKey()) {
                this.secretKey = usernameToken.getDerivedKey();
            } else {
                int keyLength = (Integer)parameters.get(SECRET_KEY_LENGTH);
                this.secretKey = usernameToken.getSecretKey(keyLength);
            }
            this.principal = usernameToken.createPrincipal();
        } else if (4096 == action) {
            if (bspCompliant) {
                BinarySecurity token = (BinarySecurity)result.get("binary-security-token");
                BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, token);
            }
            this.certs = (X509Certificate[])result.get("x509-certificates");
            Boolean validatedToken = (Boolean)result.get("validated-token");
            if (validatedToken.booleanValue()) {
                this.trustedCredential = true;
            }
        } else if (4 == action) {
            if (bspCompliant) {
                BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
            }
            this.secretKey = (byte[])result.get("secret");
            String id = (String)result.get("id");
            this.principal = new CustomTokenPrincipal(id);
        } else if (1024 == action) {
            this.secretKey = (byte[])result.get("secret");
            SecurityContextToken sct = (SecurityContextToken)result.get("security-context-token");
            this.principal = new CustomTokenPrincipal(sct.getIdentifier());
        } else if (2048 == action) {
            DerivedKeyToken dkt = (DerivedKeyToken)result.get("derived-key-token");
            int keyLength = dkt.getLength();
            if (keyLength <= 0) {
                String algorithm = (String)parameters.get(SIGNATURE_METHOD);
                keyLength = WSSecurityUtil.getKeyLength(algorithm);
            }
            byte[] secret = (byte[])result.get("secret");
            this.secretKey = dkt.deriveKey(keyLength, secret);
            this.principal = dkt.createPrincipal();
            ((WSDerivedKeyTokenPrincipal)this.principal).setSecret(secret);
        } else if (8 == action || 16 == action) {
            SAMLKeyInfo keyInfo;
            AssertionWrapper assertion = (AssertionWrapper)result.get("saml-assertion");
            if (bspCompliant) {
                BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
            }
            if ((keyInfo = assertion.getSubjectKeyInfo()) == null) {
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
            X509Certificate[] foundCerts = keyInfo.getCerts();
            if (foundCerts != null) {
                this.certs = new X509Certificate[]{foundCerts[0]};
            }
            this.secretKey = keyInfo.getSecret();
            this.publicKey = keyInfo.getPublicKey();
            this.principal = this.createPrincipalFromSAML(assertion);
        }
    }
}

