/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;

public class KerberosToken
extends Token {
    private boolean requireKeyIdentifierReference;
    private boolean useV5ApReqToken11;
    private boolean useGssV5ApReqToken11;

    public KerberosToken(SPConstants version) {
        super(version);
    }

    public boolean isRequireKeyIdentifierReference() {
        return this.requireKeyIdentifierReference;
    }

    public void setRequireKeyIdentifierReference(boolean requireKeyIdentifierReference) {
        this.requireKeyIdentifierReference = requireKeyIdentifierReference;
    }

    public boolean isV5ApReqToken11() {
        return this.useV5ApReqToken11;
    }

    public void setV5ApReqToken11(boolean v5ApReqToken11) {
        this.useV5ApReqToken11 = v5ApReqToken11;
    }

    public boolean isGssV5ApReqToken11() {
        return this.useGssV5ApReqToken11;
    }

    public void setGssV5ApReqToken11(boolean gssV5ApReqToken11) {
        this.useGssV5ApReqToken11 = gssV5ApReqToken11;
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getKerberosToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String pPrefix;
        QName name = this.constants.getSamlToken();
        String localname = name.getLocalPart();
        String namespaceURI = name.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = name.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String inclusion = this.constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if ((pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI())) == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.isRequireKeyIdentifierReference()) {
            writer.writeStartElement(prefix, "RequireKeyIdentifierReference", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isV5ApReqToken11()) {
            writer.writeStartElement(prefix, "WssKerberosV5ApReqToken11", namespaceURI);
            writer.writeEndElement();
        } else if (this.isGssV5ApReqToken11()) {
            writer.writeStartElement(prefix, "WssGssKerberosV5ApReqToken11", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

